/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.io.IOException;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.impl.pb.pd.font.PBoxPDSimpleFont;

public class PBoxPDType1Font
extends PBoxPDSimpleFont
implements org.verapdf.model.pdlayer.PDType1Font {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDType1Font.class);
    public static final String UNDEFINED_GLYPH = ".notdef";
    public static final String TYPE1_FONT_TYPE = "PDType1Font";

    public PBoxPDType1Font(PDType1Font font, RenderingMode renderingMode) {
        super(font, renderingMode, TYPE1_FONT_TYPE);
    }

    public PBoxPDType1Font(PDType1CFont font, RenderingMode renderingMode) {
        super(font, renderingMode, TYPE1_FONT_TYPE);
    }

    @Override
    public Boolean getcharSetListsAllGlyphs() {
        try {
            String charSet;
            PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
            if (fontDescriptor != null && (charSet = fontDescriptor.getCharSet()) != null) {
                String[] splittedCharSet = fontDescriptor.getCharSet().split("/");
                FontBoxFont font = ((PDSimpleFont)this.pdFontLike).getFontBoxFont();
                for (int i = 1; i < splittedCharSet.length; ++i) {
                    if (font.hasGlyph(splittedCharSet[i])) continue;
                    return Boolean.FALSE;
                }
                if (font instanceof Type1Font ? ((Type1Font)font).getCharStringsDict().size() != splittedCharSet.length : font instanceof CFFFont && ((CFFFont)font).getNumCharStrings() != splittedCharSet.length) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error while parsing embedded font program. " + e.getMessage(), e);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean getisStandard() {
        return ((PDSimpleFont)this.pdFontLike).isStandard14();
    }

    @Override
    public String getCharSet() {
        PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
        return fontDescriptor != null ? fontDescriptor.getCharSet() : null;
    }
}

