/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosIIFilter;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDInlineImage;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDInlineImage
extends PBoxPDObject
implements PDInlineImage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDInlineImage.class);
    public static final String F = "F";
    public static final String INLINE_IMAGE_TYPE = "PDInlineImage";
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDInlineImage(org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, INLINE_IMAGE_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Boolean getInterpolate() {
        return ((PDImage)this.simplePDObject).getInterpolate();
    }

    @Override
    public String getSubtype() {
        return null;
    }

    @Override
    public Boolean getisInherited() {
        return Boolean.FALSE;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "SMask": 
            case "OPI": 
            case "Alternates": 
            case "jpxStream": {
                return Collections.emptyList();
            }
            case "F": {
                return this.getFilters();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosIIFilter> getFilters() {
        List<String> filters = ((org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage)this.simplePDObject).getFilters();
        ArrayList<CosIIFilter> result = new ArrayList<CosIIFilter>();
        if (filters != null) {
            for (String filter : filters) {
                result.add(new PBCosIIFilter(filter));
            }
        }
        return result;
    }

    private List<PDColorSpace> getImageCS() {
        try {
            PDColorSpace buffer = ColorSpaceFactory.getColorSpace(((PDImage)this.simplePDObject).getColorSpace(), this.document, this.flavour);
            if (buffer != null) {
                ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
                colorSpaces.add(buffer);
                return Collections.unmodifiableList(colorSpaces);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Problems with color space obtaining from InlineImage XObject. " + e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getIntent() {
        COSDictionary imageStream = (COSDictionary)this.simplePDObject.getCOSObject();
        COSName intent = imageStream.getCOSName(COSName.getPDFName("Intent"));
        if (intent != null) {
            ArrayList<PBCosRenderingIntent> intents = new ArrayList<PBCosRenderingIntent>(1);
            intents.add(new PBCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }
}

