/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.xref;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.xref.COSXRefEntry;
import org.verapdf.cos.xref.COSXRefRange;

public class COSXRefSection {
    private Map<Integer, COSXRefEntry> entries = new TreeMap<Integer, COSXRefEntry>();

    public COSXRefSection() {
        this.entries.put(0, new COSXRefEntry(0L, 65535, 'f'));
    }

    public void add(COSKey key, long offset) {
        this.add(key, offset, 'n');
    }

    public void add(COSKey key, long offset, char free) {
        this.entries.put(key.getNumber(), new COSXRefEntry(offset, key.getGeneration(), free));
    }

    public void add(Map<COSKey, Long> offsets) {
        this.add(offsets, 'n');
    }

    public void add(Map<COSKey, Long> offsets, char free) {
        for (Map.Entry<COSKey, Long> entry : offsets.entrySet()) {
            this.add(entry.getKey(), entry.getValue(), free);
        }
    }

    public void addTo(List<COSKey> keys) {
        for (Map.Entry<Integer, COSXRefEntry> entry : this.entries.entrySet()) {
            COSKey key = new COSKey(entry.getKey(), entry.getValue().generation);
            if (entry.getValue().free == 'n') {
                keys.add(key);
                continue;
            }
            this.removeIfNumberEqual(keys, key.getNumber());
        }
    }

    public void addTo(Map<COSKey, Long> offsets) {
        for (Map.Entry<Integer, COSXRefEntry> entry : this.entries.entrySet()) {
            COSKey key = new COSKey(entry.getKey(), entry.getValue().generation);
            if (entry.getValue().free == 'n') {
                offsets.put(key, entry.getValue().offset);
                continue;
            }
            offsets.remove(new COSKey(key.getNumber(), key.getGeneration() - 1));
        }
    }

    public List<COSXRefRange> getRange() {
        ArrayList<COSXRefRange> result = new ArrayList<COSXRefRange>();
        if (this.entries.isEmpty()) {
            return result;
        }
        Iterator<Map.Entry<Integer, COSXRefEntry>> iterator = this.entries.entrySet().iterator();
        COSXRefRange segment = new COSXRefRange(iterator.next().getKey());
        while (iterator.hasNext()) {
            int nextSegment = iterator.next().getKey();
            if (nextSegment == segment.next()) {
                ++segment.count;
                continue;
            }
            result.add(segment);
            segment = new COSXRefRange(nextSegment);
        }
        result.add(segment);
        return result;
    }

    public COSXRefEntry getEntry(int number) {
        return this.entries.get(number);
    }

    public void addEntry(int number, COSXRefEntry entry) {
        this.entries.put(number, entry);
    }

    private void removeIfNumberEqual(List<COSKey> keys, int number) {
        for (COSKey key : keys) {
            if (key.getNumber() != number) continue;
            keys.remove(number);
        }
    }

    public long next() {
        if (this.entries.isEmpty()) {
            return 1L;
        }
        Iterator<Map.Entry<Integer, COSXRefEntry>> iterator = this.entries.entrySet().iterator();
        Map.Entry<Integer, COSXRefEntry> lastElement = iterator.next();
        while (iterator.hasNext()) {
            lastElement = iterator.next();
        }
        return lastElement.getKey() + 1;
    }
}

