/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.COSParser;

public class SignatureParser
extends COSParser {
    private static final Logger LOGGER = Logger.getLogger(SignatureParser.class.getCanonicalName());
    private static final byte[] EOF_STRING = "%%EOF".getBytes();
    private long[] byteRange = new long[4];
    private COSDocument document;

    public SignatureParser(SeekableInputStream stream, COSDocument document) throws IOException {
        super(stream);
        this.document = document;
    }

    private void parseDictionary() throws IOException {
        this.skipSpaces();
        this.skipExpectedCharacter('<');
        this.skipExpectedCharacter('<');
        this.skipSpaces();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            char c = (char)this.source.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            if (c == '/') {
                if (!this.parseSignatureNameValuePair()) continue;
                done = true;
                continue;
            }
            LOGGER.log(Level.FINE, "Invalid dictionary, found: '" + c + "' but expected: '/'");
            return;
        }
    }

    private void passCOSDictionaryValue() throws IOException {
        long numOffset = this.source.getOffset();
        COSObject number = this.nextObject();
        this.skipSpaces();
        if (!this.isDigit()) {
            return;
        }
        this.source.getOffset();
        COSObject generationNumber = this.nextObject();
        this.skipSpaces();
        this.skipExpectedCharacter('R');
        if (number.getType() != COSObjType.COS_INTEGER) {
            throw new IOException("expected number at offset " + numOffset + " but got" + (Object)((Object)number.getType()));
        }
        if (generationNumber.getType() != COSObjType.COS_INTEGER) {
            throw new IOException("expected number at offset " + numOffset + " but got" + (Object)((Object)generationNumber.getType()));
        }
    }

    public long[] getByteRangeBySignatureOffset(long signatureOffset) throws IOException {
        this.source.seek(signatureOffset);
        this.skipID();
        this.byteRange[0] = 0L;
        this.parseDictionary();
        this.byteRange[3] = this.getOffsetOfNextEOF(this.byteRange[2]) - this.byteRange[2];
        return this.byteRange;
    }

    private boolean parseSignatureNameValuePair() throws IOException {
        ASAtom key = this.nextObject().getName();
        if (key != ASAtom.CONTENTS) {
            this.passCOSDictionaryValue();
            return false;
        }
        this.parseSignatureValue();
        return true;
    }

    private void parseSignatureValue() throws IOException {
        this.skipSpaces();
        long numOffset1 = this.source.getOffset();
        COSObject number = this.nextObject();
        long numOffset2 = this.source.getOffset();
        this.skipSpaces();
        if (!this.isDigit()) {
            this.byteRange[1] = numOffset1;
            this.byteRange[2] = numOffset2;
            return;
        }
        long genOffset = this.source.getOffset();
        COSObject generationNumber = this.nextObject();
        this.skipSpaces();
        int c = this.source.read();
        if (c == 82) {
            if (number.getType() != COSObjType.COS_INTEGER) {
                throw new IOException("expected number at offset " + numOffset1 + " but got" + (Object)((Object)number.getType()));
            }
            if (generationNumber.getType() != COSObjType.COS_INTEGER) {
                throw new IOException("expected number at offset " + genOffset + " but got" + (Object)((Object)generationNumber.getType()));
            }
            COSKey key = new COSKey(number.getInteger().intValue(), generationNumber.getInteger().intValue());
            long keyOffset = this.document.getOffset(key);
            this.source.seek(keyOffset + this.document.getHeader().getHeaderOffset());
            this.parseSignatureValue();
        }
        if (c != 111) {
            throw new IOException("\"R\" or \"obj\" expected, but '" + (char)c + "' found.");
        }
        this.skipExpectedCharacter('b');
        this.skipExpectedCharacter('j');
        this.skipSpaces();
        numOffset1 = this.source.getOffset();
        this.nextObject();
        numOffset2 = this.source.getOffset();
        this.byteRange[1] = numOffset1;
        this.byteRange[2] = numOffset2;
    }

    private long getOffsetOfNextEOF(long currentOffset) throws IOException {
        byte[] buffer = new byte[EOF_STRING.length];
        this.source.seek(currentOffset + this.document.getHeader().getHeaderOffset());
        this.source.read(buffer);
        this.source.unread(buffer.length - 1);
        while (!Arrays.equals(buffer, EOF_STRING)) {
            this.source.read(buffer);
            if (this.source.isEOF()) {
                this.source.seek(currentOffset + this.document.getHeader().getHeaderOffset());
                return this.source.getStreamLength();
            }
            this.source.unread(buffer.length - 1);
        }
        long result = this.source.getOffset() - 1L + (long)buffer.length;
        this.source.seek(currentOffset + this.document.getHeader().getHeaderOffset());
        return result - 1L;
    }

    private void skipID() throws IOException {
        this.nextObject();
        this.objects.clear();
        this.flag = true;
    }
}

