/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.stdmetrics;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.font.stdmetrics.StandardFontMetrics;

public class AFMParser
extends BaseParser {
    private static final String START_CHAR_METRICS_STRING = "StartCharMetrics";
    private static final String FONT_NAME_STRING = "FontName";
    private static final String FAMILY_NAME_STRING = "FamilyName";
    private static final String FONT_BBOX_STRING = "FontBBox";
    private static final String ENCODING_SCHEME_STRING = "EncodingScheme";
    private static final String CHARSET_STRING = "CharacterSet";
    private static final String CAP_HEIGHT_STRING = "CapHeight";
    private static final String X_HEIGHT_STRING = "XHeight";
    private static final String ASCEND_STRING = "Ascender";
    private static final String DESCEND_STRING = "Descender";
    private static final String ITALIC_ANGLE_STRING = "ItalicAngle";
    private String fontName;
    private int nGlyphs;

    public AFMParser(ASInputStream asInputStream, String fontName) throws IOException {
        super(asInputStream);
        this.fontName = fontName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardFontMetrics parse() throws IOException {
        StandardFontMetrics res = new StandardFontMetrics();
        try {
            this.initializeToken();
            while (this.getToken().type != Token.Type.TT_EOF) {
                this.nextToken();
                this.processToken(res);
            }
        }
        finally {
            this.source.close();
        }
        return res;
    }

    private void findStartCharMetrics() throws IOException {
        do {
            this.nextToken();
        } while (this.getToken().type != Token.Type.TT_EOF && !this.getToken().getValue().equals(START_CHAR_METRICS_STRING));
        if (this.getToken().type == Token.Type.TT_EOF) {
            throw new IOException("Can't parse font metrics for predefined font " + this.fontName);
        }
    }

    private void processToken(StandardFontMetrics res) throws IOException {
        if (this.getToken().type == Token.Type.TT_KEYWORD) {
            this.skipSpaces();
            switch (this.getToken().getValue()) {
                case "StartCharMetrics": {
                    this.nextToken();
                    if (this.getToken().type == Token.Type.TT_INTEGER) {
                        this.nGlyphs = (int)this.getToken().integer;
                        for (int i = 0; i < this.nGlyphs; ++i) {
                            this.readMetricsLine(res);
                        }
                        break;
                    }
                    throw new IOException("Can't parse font metrics for predefined font " + this.fontName);
                }
                case "FontName": {
                    res.setFontName(this.getLine());
                    break;
                }
                case "FamilyName": {
                    res.setFamilyName(this.getLine());
                    break;
                }
                case "FontBBox": {
                    double[] bbox = new double[4];
                    for (int i = 0; i < 4; ++i) {
                        this.nextToken();
                        if (this.getToken().type != Token.Type.TT_INTEGER && this.getToken().type != Token.Type.TT_REAL) {
                            throw new IOException("Font BBox in AFM file for " + this.fontName + " doesn't contain 4 entries");
                        }
                        bbox[i] = this.getToken().real;
                    }
                    res.setFontBBox(bbox);
                    break;
                }
                case "EncodingScheme": {
                    res.setEncodingScheme(this.getLine());
                    break;
                }
                case "CharacterSet": {
                    res.setCharSet(this.getLine());
                    break;
                }
                case "CapHeight": {
                    res.setCapHeight(this.getNextDoubleWithCheck("Cap height"));
                    break;
                }
                case "XHeight": {
                    res.setXHeight(this.getNextDoubleWithCheck(X_HEIGHT_STRING));
                    break;
                }
                case "Ascender": {
                    res.setAscend(this.getNextDoubleWithCheck(ASCEND_STRING));
                    break;
                }
                case "Descender": {
                    res.setDescend(this.getNextDoubleWithCheck(DESCEND_STRING));
                    break;
                }
                case "ItalicAngle": {
                    res.setItalicAngle(this.getNextDoubleWithCheck("Italic angle"));
                }
            }
        }
    }

    private void readMetricsLine(StandardFontMetrics sfm) throws IOException {
        this.nextToken();
        this.nextToken();
        this.nextToken();
        this.nextToken();
        this.nextToken();
        int width = (int)this.getToken().integer;
        this.nextToken();
        this.nextToken();
        this.nextToken();
        sfm.putWidth(this.getToken().getValue(), width);
        for (int i = 0; i < 7; ++i) {
            this.nextToken();
        }
    }

    private double getNextDoubleWithCheck(String errorDescription) throws IOException {
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_INTEGER || this.getToken().type == Token.Type.TT_REAL) {
            return this.getToken().real;
        }
        throw new IOException(errorDescription + " entry in AFM file for " + this.fontName + "is not a number");
    }
}

