/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.plugins;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.verapdf.processor.plugins.Attribute;

@XmlRootElement(name="plugin")
public class PluginConfig {
    @XmlAttribute
    private final boolean enabled;
    @XmlElement
    private final String name;
    @XmlElement
    private final String version;
    @XmlElement
    private final String description;
    @XmlElement
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private final Path pluginJar;
    @XmlElement(name="attribute")
    @XmlElementWrapper(name="attributes")
    private final List<Attribute> attributes;

    private PluginConfig(boolean enabled, String name, String version, String description, Path pluginJar, List<Attribute> attributes) {
        this.enabled = enabled;
        this.name = name;
        this.version = version;
        this.description = description;
        this.pluginJar = pluginJar;
        this.attributes = attributes == null ? null : new ArrayList<Attribute>(attributes);
    }

    private PluginConfig() {
        this(false, "", "", "", FileSystems.getDefault().getPath("", new String[0]), Collections.emptyList());
    }

    public static PluginConfig fromValues(boolean enabled, String name, String version, String description, Path pluginFolder, List<Attribute> attributes) {
        return new PluginConfig(enabled, name, version, description, pluginFolder, attributes);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Path getPluginJar() {
        return this.pluginJar;
    }

    public List<Attribute> getAttributes() {
        return this.attributes == null ? Collections.emptyList() : Collections.unmodifiableList(this.attributes);
    }

    private static class PathAdapter
    extends XmlAdapter<String, Path> {
        private PathAdapter() {
        }

        public Path unmarshal(String v) throws Exception {
            Path path = Paths.get(v, new String[0]);
            return path.toAbsolutePath();
        }

        public String marshal(Path v) {
            return v.toAbsolutePath().toString();
        }
    }
}

