/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.pdmodel.graphics.color.PDJPXColorSpace;

public final class JPXFilter
extends Filter {
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        DecodeResult result = new DecodeResult(new COSDictionary());
        result.getParameters().addAll(parameters);
        BufferedImage image = this.readJPX(encoded, result);
        WritableRaster raster = image.getRaster();
        if (raster.getDataBuffer().getDataType() != 0) {
            throw new IOException("Not implemented: greater than 8-bit depth");
        }
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        decoded.write(buffer.getData());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPX(InputStream input, DecodeResult result) throws IOException {
        ImageReader reader = JPXFilter.findImageReader("JPEG2000", "Java Advanced Imaging (JAI) Image I/O Tools are not installed");
        ImageInputStream iis = null;
        try {
            BufferedImage image;
            iis = ImageIO.createImageInputStream(input);
            reader.setInput(iis, true, true);
            try {
                image = reader.read(0);
            }
            catch (Exception e) {
                throw new IOException("Could not read JPEG 2000 (JPX) image", e);
            }
            COSDictionary parameters = result.getParameters();
            parameters.setInt(COSName.BITS_PER_COMPONENT, image.getColorModel().getComponentSize(0));
            if (!parameters.getBoolean(COSName.IMAGE_MASK, false)) {
                parameters.setItem(COSName.DECODE, null);
            }
            parameters.setInt(COSName.WIDTH, image.getWidth());
            parameters.setInt(COSName.HEIGHT, image.getHeight());
            if (!parameters.containsKey(COSName.COLORSPACE)) {
                result.setColorSpace(new PDJPXColorSpace(image.getColorModel().getColorSpace()));
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
            reader.dispose();
        }
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        throw new UnsupportedOperationException("JPX encoding not implemented");
    }
}

