/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccessRead;

public class RandomAccessReadWrapper
implements RandomAccessRead {
    private boolean isClosed;
    private RandomAccessRead randomAccessInput;
    private final long startPosition;
    private final long inputLength;

    public RandomAccessReadWrapper(RandomAccessRead input, long offset, long length) throws IOException {
        this.randomAccessInput = input;
        this.startPosition = offset;
        this.inputLength = length;
        this.seek(0L);
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("RandomAccessFile already closed");
        }
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.randomAccessInput.getPosition() + this.startPosition;
    }

    @Override
    public void seek(long newOffset) throws IOException {
        this.checkClosed();
        this.randomAccessInput.seek(newOffset + this.startPosition);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.randomAccessInput.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        return this.randomAccessInput.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.inputLength - this.getPosition(), Integer.MAX_VALUE);
    }

    @Override
    public long length() throws IOException {
        return this.inputLength;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.randomAccessInput = null;
    }

    @Override
    public boolean isClosed() {
        if (this.isClosed || this.randomAccessInput == null) {
            return true;
        }
        return this.randomAccessInput.isClosed();
    }

    @Override
    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.rewind(1);
        }
        return result;
    }

    @Override
    public void rewind(int bytes) throws IOException {
        this.seek(this.getPosition() - (long)bytes);
    }

    @Override
    public byte[] readFully(int length) throws IOException {
        byte[] b = new byte[length];
        for (int bytesRead = this.read(b); bytesRead < length; bytesRead += this.read(b, bytesRead, length - bytesRead)) {
        }
        return b;
    }

    @Override
    public boolean isEOF() throws IOException {
        int peek = this.peek();
        return peek == -1;
    }
}

