/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FileSystemFontProvider;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.FontProvider;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

final class FontMapper {
    private static final FontCache fontCache = new FontCache();
    private static final Log log = LogFactory.getLog(FontMapper.class);
    private static FontProvider fontProvider;
    private static Map<String, FontInfo> fontInfoByName;
    private static final TrueTypeFont lastResortFont;
    private static final Map<String, List<String>> substitutes;

    private FontMapper() {
    }

    public static synchronized void setProvider(FontProvider fontProvider) {
        FontMapper.fontProvider = fontProvider;
        fontInfoByName = FontMapper.createFontInfoByName(fontProvider.getFontInfo());
    }

    public static synchronized FontProvider getProvider() {
        if (fontProvider == null) {
            FontMapper.setProvider(DefaultFontProvider.INSTANCE);
        }
        return fontProvider;
    }

    public static FontCache getFontCache() {
        return fontCache;
    }

    private static Map<String, FontInfo> createFontInfoByName(List<? extends FontInfo> fontInfoList) {
        LinkedHashMap<String, FontInfo> map = new LinkedHashMap<String, FontInfo>();
        for (FontInfo fontInfo : fontInfoList) {
            for (String name : FontMapper.getPostScriptNames(fontInfo.getPostScriptName())) {
                map.put(name, fontInfo);
            }
        }
        return map;
    }

    private static Set<String> getPostScriptNames(String postScriptName) {
        HashSet<String> names = new HashSet<String>();
        names.add(postScriptName);
        names.add(postScriptName.replaceAll("-", ""));
        return names;
    }

    private static List<String> copySubstitutes(String postScriptName) {
        return new ArrayList<String>((Collection)substitutes.get(postScriptName));
    }

    public static void addSubstitute(String match, String replace) {
        if (!substitutes.containsKey(match)) {
            substitutes.put(match, new ArrayList());
        }
        substitutes.get(match).add(replace);
    }

    private static List<String> getSubstitutes(String postScriptName) {
        List<String> subs = substitutes.get(postScriptName.replaceAll(" ", ""));
        if (subs != null) {
            return subs;
        }
        return Collections.emptyList();
    }

    private static String getFallbackFontName(PDFontDescriptor fontDescriptor) {
        String fontName;
        if (fontDescriptor != null) {
            boolean isBold = false;
            String name = fontDescriptor.getFontName();
            if (name != null) {
                String lower = fontDescriptor.getFontName().toLowerCase();
                boolean bl = isBold = lower.contains("bold") || lower.contains("black") || lower.contains("heavy");
            }
            if (fontDescriptor.isFixedPitch()) {
                fontName = "Courier";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            } else if (fontDescriptor.isSerif()) {
                fontName = "Times";
                fontName = isBold && fontDescriptor.isItalic() ? fontName + "-BoldItalic" : (isBold ? fontName + "-Bold" : (fontDescriptor.isItalic() ? fontName + "-Italic" : fontName + "-Roman"));
            } else {
                fontName = "Helvetica";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            }
        } else {
            fontName = "Times-Roman";
        }
        return fontName;
    }

    public static FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
        TrueTypeFont ttf = (TrueTypeFont)FontMapper.findFont(FontFormat.TTF, baseFont);
        if (ttf != null) {
            return new FontMapping<TrueTypeFont>(ttf, false);
        }
        String fontName = FontMapper.getFallbackFontName(fontDescriptor);
        ttf = (TrueTypeFont)FontMapper.findFont(FontFormat.TTF, fontName);
        if (ttf == null) {
            log.debug("Using last-resort fallback for TTF font '" + fontName + "'");
            ttf = lastResortFont;
        }
        return new FontMapping<TrueTypeFont>(ttf, true);
    }

    public static FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
        FontBoxFont font = FontMapper.findFontBoxFont(baseFont);
        if (font != null) {
            return new FontMapping<FontBoxFont>(font, false);
        }
        String fallbackName = FontMapper.getFallbackFontName(fontDescriptor);
        font = FontMapper.findFontBoxFont(fallbackName);
        if (font == null) {
            log.debug("Using last-resort fallback for font '" + fallbackName + "'");
            font = lastResortFont;
        }
        return new FontMapping<FontBoxFont>(font, true);
    }

    private static FontBoxFont findFontBoxFont(String postScriptName) {
        Type1Font t1 = (Type1Font)FontMapper.findFont(FontFormat.PFB, postScriptName);
        if (t1 != null) {
            return t1;
        }
        CFFFont cff = (CFFFont)FontMapper.findFont(FontFormat.OTF, postScriptName);
        if (cff instanceof CFFType1Font) {
            return cff;
        }
        TrueTypeFont ttf = (TrueTypeFont)FontMapper.findFont(FontFormat.TTF, postScriptName);
        if (ttf != null) {
            return ttf;
        }
        return null;
    }

    private static FontBoxFont findFont(FontFormat format, String postScriptName) {
        FontInfo info;
        if (fontProvider == null) {
            FontMapper.getProvider();
        }
        if ((info = FontMapper.getFont(format, postScriptName)) != null) {
            return info.getFont();
        }
        info = FontMapper.getFont(format, postScriptName.replaceAll("-", ""));
        if (info != null) {
            return info.getFont();
        }
        for (String substituteName : FontMapper.getSubstitutes(postScriptName)) {
            info = FontMapper.getFont(format, substituteName);
            if (info == null) continue;
            return info.getFont();
        }
        info = FontMapper.getFont(format, postScriptName.replaceAll(",", "-"));
        if (info != null) {
            return info.getFont();
        }
        return null;
    }

    private static FontInfo getFont(FontFormat format, String postScriptName) {
        if (postScriptName.contains("+")) {
            postScriptName = postScriptName.substring(postScriptName.indexOf("+") + 1);
        }
        FontInfo info = fontInfoByName.get(postScriptName);
        return null;
    }

    public static CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        String collection;
        OpenTypeFont otf1 = (OpenTypeFont)FontMapper.findFont(FontFormat.OTF, baseFont);
        if (otf1 != null) {
            return new CIDFontMapping(otf1, null, false);
        }
        TrueTypeFont ttf = (TrueTypeFont)FontMapper.findFont(FontFormat.TTF, baseFont);
        if (ttf != null) {
            return new CIDFontMapping(null, ttf, false);
        }
        if (cidSystemInfo != null && ((collection = cidSystemInfo.getRegistry() + "-" + cidSystemInfo.getOrdering()).equals("Adobe-GB1") || collection.equals("Adobe-CNS1") || collection.equals("Adobe-Japan1") || collection.equals("Adobe-Korea1"))) {
            for (FontInfo info : fontInfoByName.values()) {
                if (info.getCIDSystemInfo() == null || !info.getCIDSystemInfo().getRegistry().equals(cidSystemInfo.getRegistry()) || !info.getCIDSystemInfo().getOrdering().equals(cidSystemInfo.getOrdering())) continue;
                return new CIDFontMapping((OpenTypeFont)info.getFont(), null, true);
            }
        }
        return new CIDFontMapping(null, lastResortFont, true);
    }

    static /* synthetic */ FontCache access$000() {
        return fontCache;
    }

    static {
        try {
            String ttfName = "org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf";
            URL url = FontMapper.class.getClassLoader().getResource(ttfName);
            if (url == null) {
                throw new IOException("Error loading resource: " + ttfName);
            }
            InputStream ttfStream = url.openStream();
            TTFParser ttfParser = new TTFParser();
            lastResortFont = ttfParser.parse(ttfStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        substitutes = new HashMap<String, List<String>>();
        substitutes.put("Courier", Arrays.asList("CourierNew", "CourierNewPSMT", "LiberationMono", "NimbusMonL-Regu"));
        substitutes.put("Courier-Bold", Arrays.asList("CourierNewPS-BoldMT", "CourierNew-Bold", "LiberationMono-Bold", "NimbusMonL-Bold"));
        substitutes.put("Courier-Oblique", Arrays.asList("CourierNewPS-ItalicMT", "CourierNew-Italic", "LiberationMono-Italic", "NimbusMonL-ReguObli"));
        substitutes.put("Courier-BoldOblique", Arrays.asList("CourierNewPS-BoldItalicMT", "CourierNew-BoldItalic", "LiberationMono-BoldItalic", "NimbusMonL-BoldObli"));
        substitutes.put("Helvetica", Arrays.asList("ArialMT", "Arial", "LiberationSans", "NimbusSanL-Regu"));
        substitutes.put("Helvetica-Bold", Arrays.asList("Arial-BoldMT", "Arial-Bold", "LiberationSans-Bold", "NimbusSanL-Bold"));
        substitutes.put("Helvetica-Oblique", Arrays.asList("Arial-ItalicMT", "Arial-Italic", "Helvetica-Italic", "LiberationSans-Italic", "NimbusSanL-ReguItal"));
        substitutes.put("Helvetica-BoldOblique", Arrays.asList("Arial-BoldItalicMT", "Helvetica-BoldItalic", "LiberationSans-BoldItalic", "NimbusSanL-BoldItal"));
        substitutes.put("Times-Roman", Arrays.asList("TimesNewRomanPSMT", "TimesNewRoman", "TimesNewRomanPS", "LiberationSerif", "NimbusRomNo9L-Regu"));
        substitutes.put("Times-Bold", Arrays.asList("TimesNewRomanPS-BoldMT", "TimesNewRomanPS-Bold", "TimesNewRoman-Bold", "LiberationSerif-Bold", "NimbusRomNo9L-Medi"));
        substitutes.put("Times-Italic", Arrays.asList("TimesNewRomanPS-ItalicMT", "TimesNewRomanPS-Italic", "TimesNewRoman-Italic", "LiberationSerif-Italic", "NimbusRomNo9L-ReguItal"));
        substitutes.put("Times-BoldItalic", Arrays.asList("TimesNewRomanPS-BoldItalicMT", "TimesNewRomanPS-BoldItalic", "TimesNewRoman-BoldItalic", "LiberationSerif-BoldItalic", "NimbusRomNo9L-MediItal"));
        substitutes.put("Symbol", Arrays.asList("Symbol", "SymbolMT", "StandardSymL"));
        substitutes.put("ZapfDingbats", Arrays.asList("ZapfDingbatsITC", "Dingbats", "MS-Gothic"));
        for (String baseName : Standard14Fonts.getNames()) {
            if (substitutes.containsKey(baseName)) continue;
            String mappedName = Standard14Fonts.getMappedFontName(baseName);
            substitutes.put(baseName, FontMapper.copySubstitutes(mappedName));
        }
    }

    private static class DefaultFontProvider {
        private static final FontProvider INSTANCE = new FileSystemFontProvider(FontMapper.access$000());

        private DefaultFontProvider() {
        }
    }
}

