/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.features.objects.ICCProfileFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBICCProfileFeaturesObjectAdapter
implements ICCProfileFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBICCProfileFeaturesObjectAdapter.class);
    private static final int HEADER_SIZE = 128;
    private static final int FF_FLAG = 255;
    private static final int REQUIRED_LENGTH = 4;
    private static final int TAGINFO_LENGTH = 12;
    private static final int BITSINBYTE = 8;
    private static final int VERSION_BYTE = 8;
    private static final int SUBVERSION_BYTE = 9;
    private static final int CMMTYPE_BEGIN = 4;
    private static final int CMMTYPE_END = 8;
    private static final int DATACOLORSPACE_BEGIN = 16;
    private static final int DATACOLORSPACE_END = 20;
    private static final int RENDERINGINTENT_BEGIN = 64;
    private static final int RENDERINGINTENT_END = 68;
    private static final int PROFILEID_BEGIN = 84;
    private static final int PROFILEID_END = 100;
    private static final int DEVICEMODEL_BEGIN = 52;
    private static final int DEVICEMODEL_END = 56;
    private static final int DEVICEMANUFACTURER_BEGIN = 48;
    private static final int DEVICEMANUFACTURER_END = 52;
    private static final int CREATOR_BEGIN = 80;
    private static final int CREATOR_END = 84;
    private static final int CREATION_YEAR = 24;
    private static final int CREATION_MONTH = 26;
    private static final int CREATION_DAY = 28;
    private static final int CREATION_HOUR = 30;
    private static final int CREATION_MIN = 32;
    private static final int CREATION_SEC = 34;
    private static final int FIRST_RECORD_STRING_LENGTH_IN_TEXTDESCRIPTIONTYPE_BEGIN = 8;
    private static final int FIRST_RECORD_STRING_LENGTH_IN_TEXTDESCRIPTIONTYPE_END = 12;
    private static final int NUMBER_OF_RECORDS_IN_MULTILOCALIZEDUNICODETYPE_BEGIN = 8;
    private static final int NUMBER_OF_RECORDS_IN_MULTILOCALIZEDUNICODETYPE_END = 12;
    private static final int LENGTH_OF_RECORD_IN_MULTILOCALIZEDUNICODETYPE_END = 12;
    private COSStream profile;
    private String id;
    private String version;
    private String cmmType;
    private String dataColorSpace;
    private String creator;
    private Calendar creationDate;
    private String defaultRenderingIntent;
    private String copyright;
    private String description;
    private String profileID;
    private String deviceModel;
    private String deviceManufacturer;
    private List<String> errors;

    public PBICCProfileFeaturesObjectAdapter(COSStream profile, String id) {
        this.profile = profile;
        this.id = id;
        this.init();
    }

    private void init() {
        if (this.profile != null) {
            this.errors = new ArrayList<String>();
            try {
                byte[] profileBytes = PBAdapterHelper.inputStreamToByteArray(this.profile.getUnfilteredStream());
                if (profileBytes.length < 128) {
                    this.errors.add("ICCProfile contains less than 128 bytes");
                } else {
                    this.version = PBICCProfileFeaturesObjectAdapter.getVersion(profileBytes);
                    this.cmmType = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 4, 8);
                    this.dataColorSpace = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 16, 20);
                    this.creator = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 80, 84);
                    this.creationDate = PBICCProfileFeaturesObjectAdapter.getCreationDate(profileBytes);
                    this.defaultRenderingIntent = PBICCProfileFeaturesObjectAdapter.getIntent(PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 64, 68));
                    this.copyright = PBICCProfileFeaturesObjectAdapter.getStringTag(profileBytes, "cprt", true);
                    this.description = PBICCProfileFeaturesObjectAdapter.getStringTag(profileBytes, "desc", false);
                    this.profileID = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 84, 100);
                    this.deviceModel = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 52, 56);
                    this.deviceManufacturer = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, 48, 52);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Reading byte array from InputStream error", e);
                this.errors.add(e.getMessage());
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getCMMType() {
        return this.cmmType;
    }

    @Override
    public String getDataColorSpace() {
        return this.dataColorSpace;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getDefaultRenderingIntent() {
        return this.defaultRenderingIntent;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getProfileID() {
        return this.profileID;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.profile != null;
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    @Override
    public InputStream getMetadataStream() {
        COSBase cosBase;
        if (this.profile != null && (cosBase = this.profile.getDictionaryObject(COSName.METADATA)) instanceof COSStream) {
            return PBAdapterHelper.getMetadataStream(new PDMetadata((COSStream)cosBase));
        }
        return null;
    }

    @Override
    public InputStream getData() {
        if (this.profile != null) {
            try {
                return this.profile.getUnfilteredStream();
            }
            catch (IOException e) {
                LOGGER.debug("Can not get iccProfile stream", e);
            }
        }
        return null;
    }

    @Override
    public Integer getN() {
        COSBase nBase;
        if (this.profile != null && (nBase = this.profile.getDictionaryObject(COSName.N)) instanceof COSInteger) {
            return ((COSInteger)nBase).intValue();
        }
        return null;
    }

    @Override
    public List<Double> getRange() {
        if (this.profile != null) {
            ArrayList<Double> range = new ArrayList<Double>();
            COSBase rangeBase = this.profile.getDictionaryObject(COSName.RANGE);
            if (rangeBase instanceof COSArray) {
                COSArray array = (COSArray)rangeBase;
                for (COSBase baseNumb : array) {
                    if (baseNumb instanceof COSNumber) {
                        range.add(((COSNumber)baseNumb).doubleValue());
                        continue;
                    }
                    range.add(null);
                }
            } else {
                Integer n = this.getN();
                if (n != null) {
                    for (int i = 0; i < n; ++i) {
                        range.add(0.0);
                        range.add(1.0);
                    }
                }
            }
            return Collections.unmodifiableList(range);
        }
        return Collections.emptyList();
    }

    private static String getIntent(String str) {
        if (str == null) {
            return "Perceptual";
        }
        switch (str) {
            case "\u0000\u0000\u0000\u0001": {
                return "Media-Relative Colorimetric";
            }
            case "\u0000\u0000\u0000\u0002": {
                return "Saturation";
            }
            case "\u0000\u0000\u0000\u0003": {
                return "ICC-Absolute Colorimetric";
            }
        }
        return str;
    }

    private static String getVersion(byte[] header) {
        if (header[8] == 0 && header[9] == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(header[8] & 0xFF).append(".");
        builder.append((header[9] & 0xFF) >>> 4);
        return builder.toString();
    }

    private static String getString(byte[] header, int begin, int end) {
        StringBuilder builder = new StringBuilder();
        boolean isEmpty = true;
        for (int i = begin; i < end; ++i) {
            if (header[i] != 0) {
                isEmpty = false;
            }
            builder.append((char)header[i]);
        }
        return isEmpty ? null : builder.toString();
    }

    private static Calendar getCreationDate(byte[] header) {
        int year = PBICCProfileFeaturesObjectAdapter.getCreationPart(header, 24);
        int month = PBICCProfileFeaturesObjectAdapter.getCreationPart(header, 26);
        int day = PBICCProfileFeaturesObjectAdapter.getCreationPart(header, 28);
        int hour = PBICCProfileFeaturesObjectAdapter.getCreationPart(header, 30);
        int min = PBICCProfileFeaturesObjectAdapter.getCreationPart(header, 32);
        int sec = PBICCProfileFeaturesObjectAdapter.getCreationPart(header, 34);
        if (year != 0 || month != 0 || day != 0 || hour != 0 || min != 0 || sec != 0) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
            cal.set(year, month - 1, day, hour, min, sec);
            cal.set(14, 0);
            return cal;
        }
        return null;
    }

    private static int getCreationPart(byte[] header, int off) {
        int part = header[off] & 0xFF;
        part <<= 8;
        return part += header[off + 1] & 0xFF;
    }

    private static String getStringTag(byte[] profileBytes, String tagName, boolean isCprt) {
        if (profileBytes.length < 132) {
            return null;
        }
        int tagsNumberRemained = PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, 128, 132));
        int curOffset = 132;
        while (tagsNumberRemained-- > 0 && curOffset + 12 <= profileBytes.length) {
            String tag = new String(Arrays.copyOfRange(profileBytes, curOffset, curOffset + 4));
            if (tag.equals(tagName)) {
                int length;
                curOffset += 4;
                int offset = PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, curOffset, curOffset + 4));
                if (profileBytes.length < offset + (length = PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, curOffset += 4, curOffset + 4)))) {
                    return null;
                }
                String type = new String(Arrays.copyOfRange(profileBytes, offset, offset + 4));
                if ("mluc".equals(type)) {
                    int number = PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, offset + 8, offset + 12));
                    int recOffset = offset + 12 + 4;
                    for (int i = 0; i < number; ++i) {
                        String local = PBICCProfileFeaturesObjectAdapter.getString(profileBytes, recOffset, recOffset + 4);
                        if ("enUS".equals(local)) {
                            length = PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, recOffset + 4, recOffset + 4 + 4));
                            return new String(Arrays.copyOfRange(profileBytes, offset += PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, recOffset + 8, recOffset + 8 + 4)), offset + length), StandardCharsets.UTF_16BE).trim();
                        }
                        recOffset += 12;
                    }
                    return null;
                }
                if ("desc".equals(type)) {
                    length = PBICCProfileFeaturesObjectAdapter.byteArrayToInt(Arrays.copyOfRange(profileBytes, offset + 8, offset + 12));
                    offset += 12;
                } else if (isCprt) {
                    offset += 4;
                    length -= 4;
                } else {
                    return null;
                }
                return new String(Arrays.copyOfRange(profileBytes, offset, offset + length), StandardCharsets.US_ASCII).trim();
            }
            curOffset += 12;
        }
        return null;
    }

    private static int byteArrayToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }
}

