/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.impl.pb.cos.PBCosLang;
import org.verapdf.model.impl.pb.pd.PBoxPDAcroForm;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.impl.pb.pd.PBoxPDOCProperties;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDOutputIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDPage;
import org.verapdf.model.impl.pb.pd.PBoxPDStructTreeRoot;
import org.verapdf.model.impl.pb.pd.signatures.PBoxPDPerms;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDOCProperties;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.model.pdlayer.PDPerms;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.model.tools.OutlinesHelper;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDDocument
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDDocument {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDDocument.class);
    public static final String PD_DOCUMENT_TYPE = "PDDocument";
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String OUTPUT_INTENTS = "outputIntents";
    public static final String ACRO_FORMS = "AcroForm";
    public static final String ACTIONS = "AA";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OUTLINES = "Outlines";
    public static final String STRUCTURE_TREE_ROOT = "StructTreeRoot";
    public static final String ALTERNATE_PRESENTATIONS = "AlternatePresentations";
    public static final String OC_PROPERTIES = "OCProperties";
    public static final String LANG = "Lang";
    public static final String PERMS = "Perms";
    public static final int MAX_NUMBER_OF_ACTIONS = 5;
    private final PDDocumentCatalog catalog = this.getDocumentCatalog();
    private final PDFAFlavour flavour;

    public PBoxPDDocument(PDDocument document, PDFAFlavour flavour) {
        super(document, PD_DOCUMENT_TYPE);
        this.flavour = flavour;
    }

    private PDDocumentCatalog getDocumentCatalog() {
        try {
            COSDictionary object = (COSDictionary)this.document.getDocument().getCatalog().getObject();
            return new PDDocumentCatalog(this.document, object);
        }
        catch (IOException e) {
            LOGGER.debug("Catalog cannot be found.");
            LOGGER.debug(e);
            return null;
        }
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Outlines": {
                return this.getOutlines();
            }
            case "OpenAction": {
                return this.getOpenAction();
            }
            case "AA": {
                return this.getActions();
            }
            case "pages": {
                return this.getPages();
            }
            case "metadata": {
                return this.getMetadata();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "AcroForm": {
                return this.getAcroForms();
            }
            case "StructTreeRoot": {
                return this.getStructureTreeRoot();
            }
            case "OCProperties": {
                return this.getOCProperties();
            }
            case "Lang": {
                return this.getLang();
            }
            case "Perms": {
                return this.getPerms();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOutline> getOutlines() {
        return OutlinesHelper.getOutlines(this.catalog);
    }

    private List<PDAction> getOpenAction() {
        if (this.catalog != null) {
            try {
                PDDestinationOrAction openAction = this.catalog.getOpenAction();
                if (openAction instanceof org.apache.pdfbox.pdmodel.interactive.action.PDAction) {
                    ArrayList<PDAction> actions = new ArrayList<PDAction>(1);
                    this.addAction(actions, (org.apache.pdfbox.pdmodel.interactive.action.PDAction)openAction);
                    return Collections.unmodifiableList(actions);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Problems with open action obtaining. " + e.getMessage(), e);
            }
        }
        return Collections.emptyList();
    }

    private List<PDAction> getActions() {
        PDDocumentCatalogAdditionalActions pbActions = this.getAdditionalAction();
        if (pbActions != null) {
            ArrayList<PDAction> actions = new ArrayList<PDAction>(5);
            org.apache.pdfbox.pdmodel.interactive.action.PDAction buffer = pbActions.getDP();
            this.addAction(actions, buffer);
            buffer = pbActions.getDS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWP();
            this.addAction(actions, buffer);
            buffer = pbActions.getWS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWC();
            this.addAction(actions, buffer);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private PDDocumentCatalogAdditionalActions getAdditionalAction() {
        COSDictionary catalogLocal;
        COSBase aaDictionary;
        if (this.catalog != null && (aaDictionary = (catalogLocal = this.catalog.getCOSObject()).getDictionaryObject(COSName.AA)) instanceof COSDictionary) {
            return new PDDocumentCatalogAdditionalActions((COSDictionary)aaDictionary);
        }
        return null;
    }

    private List<org.verapdf.model.pdlayer.PDPage> getPages() {
        PDPageTree pageTree = this.document.getPages();
        ArrayList<PBoxPDPage> pages = new ArrayList<PBoxPDPage>(pageTree.getCount());
        for (PDPage page : pageTree) {
            pages.add(new PBoxPDPage(page, this.document, this.flavour));
        }
        return Collections.unmodifiableList(pages);
    }

    private List<PDMetadata> getMetadata() {
        org.apache.pdfbox.pdmodel.common.PDMetadata meta;
        if (this.catalog != null && (meta = this.catalog.getMetadata()) != null && meta.getCOSObject() != null) {
            ArrayList<PBoxPDMetadata> metadata = new ArrayList<PBoxPDMetadata>(1);
            metadata.add(new PBoxPDMetadata(meta, Boolean.TRUE, this.document, this.flavour));
            return Collections.unmodifiableList(metadata);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDOutputIntent> getOutputIntents() {
        if (this.catalog != null) {
            List<PDOutputIntent> pdfboxOutputIntents = this.catalog.getOutputIntents();
            ArrayList<PBoxPDOutputIntent> outputIntents = new ArrayList<PBoxPDOutputIntent>(pdfboxOutputIntents.size());
            for (PDOutputIntent intent : pdfboxOutputIntents) {
                outputIntents.add(new PBoxPDOutputIntent(intent, this.document, this.flavour));
            }
            return Collections.unmodifiableList(outputIntents);
        }
        return Collections.emptyList();
    }

    private List<PDAcroForm> getAcroForms() {
        org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm form;
        if (this.catalog != null && (form = this.catalog.getAcroForm()) != null) {
            ArrayList<PBoxPDAcroForm> forms = new ArrayList<PBoxPDAcroForm>(1);
            forms.add(new PBoxPDAcroForm(form, this.document, this.flavour));
            return Collections.unmodifiableList(forms);
        }
        return Collections.emptyList();
    }

    private List<PDStructTreeRoot> getStructureTreeRoot() {
        PDStructureTreeRoot root;
        if (this.catalog != null && (root = this.catalog.getStructureTreeRoot()) != null) {
            ArrayList<PBoxPDStructTreeRoot> treeRoot = new ArrayList<PBoxPDStructTreeRoot>(1);
            treeRoot.add(new PBoxPDStructTreeRoot(root, this.flavour));
            return Collections.unmodifiableList(treeRoot);
        }
        return Collections.emptyList();
    }

    private List<PDPerms> getPerms() {
        COSDictionary perms;
        if (this.catalog != null && (perms = (COSDictionary)this.catalog.getCOSObject().getDictionaryObject(COSName.PERMS)) != null) {
            ArrayList<PBoxPDPerms> list = new ArrayList<PBoxPDPerms>(1);
            list.add(new PBoxPDPerms(perms));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAlternatePresentations() {
        COSBase alternatePresentations;
        COSDictionary rawCatalog;
        COSDictionary namesDictionary;
        if (this.catalog != null && (namesDictionary = (COSDictionary)(rawCatalog = this.catalog.getCOSObject()).getDictionaryObject(COSName.NAMES)) != null && (alternatePresentations = namesDictionary.getDictionaryObject(COSName.getPDFName(ALTERNATE_PRESENTATIONS))) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<PDOCProperties> getOCProperties() {
        PDOptionalContentProperties pBoxOCProperties;
        if (this.catalog != null && (pBoxOCProperties = this.catalog.getOCProperties()) != null) {
            ArrayList<PDOCProperties> result = new ArrayList<PDOCProperties>();
            PBoxPDOCProperties ocProperties = new PBoxPDOCProperties(pBoxOCProperties);
            result.add(ocProperties);
            return result;
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSBase baseLang;
        if (this.catalog != null && (baseLang = this.catalog.getCOSObject().getDictionaryObject(COSName.LANG)) instanceof COSString) {
            ArrayList<PBCosLang> list = new ArrayList<PBCosLang>(1);
            list.add(new PBCosLang((COSString)baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

