/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.FeaturesObjectAdapter;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public abstract class FeaturesObject {
    protected FeaturesObjectAdapter adapter;
    private final List<String> errors = new ArrayList<String>();

    FeaturesObject(FeaturesObjectAdapter adapter) {
        this.adapter = adapter;
    }

    public void registerNewError(String error) {
        this.errors.add(error);
    }

    public abstract FeatureObjectType getType();

    public final FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        this.errors.clear();
        if (this.adapter.isPDFObjectPresent()) {
            FeatureTreeNode root = this.collectFeatures();
            this.errors.addAll(this.adapter.getErrors());
            if (!this.errors.isEmpty()) {
                for (String error : this.errors) {
                    ErrorsHelper.addErrorIntoCollection(collection, root, error);
                }
            }
            collection.addNewFeatureTree(this.getType(), root);
            return root;
        }
        return null;
    }

    protected abstract FeatureTreeNode collectFeatures() throws FeatureParsingException;

    public abstract FeaturesData getData();

    protected static String generateVariableXPath(String ... node) {
        if (node == null || node.length == 0) {
            throw new IllegalArgumentException("There should be at least one node");
        }
        StringBuilder builder = new StringBuilder(node[0]);
        for (int i = 1; i < node.length; ++i) {
            builder.append("/").append(node[i]);
        }
        return builder.toString();
    }

    protected static String generateAttributeXPath(String ... node) {
        if (node == null || node.length < 2) {
            throw new IllegalArgumentException("There should be at least two nodes for attribute path");
        }
        StringBuilder builder = new StringBuilder(node[0]);
        for (int i = 1; i < node.length - 1; ++i) {
            builder.append("/").append(node[i]);
        }
        builder.append("/@").append(node[node.length - 1]);
        return builder.toString();
    }
}

