/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.PageFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PageFeaturesObject
extends FeaturesObject {
    private static final String ID = "id";
    private static final String PAGE = "page";
    private static final String ROTATION = "rotation";
    private static final String SCALING = "scaling";

    public PageFeaturesObject(PageFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.PAGE;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        String thumb;
        Double scaling;
        PageFeaturesObjectAdapter pageAdapter = (PageFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(PAGE);
        root.setAttribute("orderNumber", Integer.toString(pageAdapter.getIndex()));
        double[] mediaBox = pageAdapter.getMediaBox();
        CreateNodeHelper.addWidthHeightFeatures(mediaBox, root);
        CreateNodeHelper.addBoxFeature("mediaBox", mediaBox, root);
        CreateNodeHelper.addBoxFeature("cropBox", pageAdapter.getCropBox(), root);
        CreateNodeHelper.addBoxFeature("trimBox", pageAdapter.getTrimBox(), root);
        CreateNodeHelper.addBoxFeature("bleedBox", pageAdapter.getBleedBox(), root);
        CreateNodeHelper.addBoxFeature("artBox", pageAdapter.getArtBox(), root);
        Long rotation = pageAdapter.getRotation();
        if (rotation != null) {
            root.addChild(ROTATION).setValue(String.valueOf(rotation));
        }
        if ((scaling = pageAdapter.getScaling()) != null) {
            root.addChild(SCALING).setValue(String.format("%.3f", scaling));
        }
        if ((thumb = pageAdapter.getThumb()) != null) {
            FeatureTreeNode thumbNode = root.addChild("thumbnail");
            thumbNode.setAttribute(ID, thumb);
        }
        CreateNodeHelper.parseMetadata(pageAdapter.getMetadataStream(), "metadata", root, this);
        CreateNodeHelper.parseIDSet(pageAdapter.getAnnotsId(), "annotation", "annotations", root);
        this.parseResources(root);
        return root;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        PageFeaturesObjectAdapter pageAdapter = (PageFeaturesObjectAdapter)this.adapter;
        Set<String> extGStateChild = pageAdapter.getExtGStateChild();
        Set<String> colorSpaceChild = pageAdapter.getColorSpaceChild();
        Set<String> patternChild = pageAdapter.getPatternChild();
        Set<String> shadingChild = pageAdapter.getShadingChild();
        Set<String> xobjectChild = pageAdapter.getXObjectChild();
        Set<String> fontChild = pageAdapter.getFontChild();
        Set<String> propertiesChild = pageAdapter.getPropertiesChild();
        if (extGStateChild != null && !extGStateChild.isEmpty() || colorSpaceChild != null && !colorSpaceChild.isEmpty() || patternChild != null && !patternChild.isEmpty() || shadingChild != null && !shadingChild.isEmpty() || xobjectChild != null && !xobjectChild.isEmpty() || fontChild != null && !fontChild.isEmpty() || propertiesChild != null && !propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            CreateNodeHelper.parseIDSet(extGStateChild, "graphicsState", "graphicsStates", resources);
            CreateNodeHelper.parseIDSet(colorSpaceChild, "colorSpace", "colorSpaces", resources);
            CreateNodeHelper.parseIDSet(patternChild, "pattern", "patterns", resources);
            CreateNodeHelper.parseIDSet(shadingChild, "shading", "shadings", resources);
            CreateNodeHelper.parseIDSet(xobjectChild, "xobject", "xobjects", resources);
            CreateNodeHelper.parseIDSet(fontChild, "font", "fonts", resources);
            CreateNodeHelper.parseIDSet(propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Width", PageFeaturesObject.generateVariableXPath(PAGE, "width"), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Height", PageFeaturesObject.generateVariableXPath(PAGE, "height"), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Rotation", PageFeaturesObject.generateVariableXPath(PAGE, ROTATION), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Scaling", PageFeaturesObject.generateVariableXPath(PAGE, SCALING), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Error IDs", PageFeaturesObject.generateAttributeXPath(PAGE, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

