/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class LogoPanel
extends JPanel {
    private static final long serialVersionUID = -3623071197419943686L;
    private final transient BufferedImage logo;
    private int borderWidth;
    private Color background;

    LogoPanel(String logoName, Color backgroundColor, int borderWidth) throws IOException {
        this.borderWidth = borderWidth;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoName);){
            this.logo = ImageIO.read(is);
        }
        this.background = backgroundColor;
        this.setLayout(null);
        this.setBackground(backgroundColor);
        this.setPreferredSize(new Dimension(450, 200));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int imageHeight = this.getHeight() - this.borderWidth * 2;
        int imageWidth = this.logo.getWidth() * imageHeight / this.logo.getHeight();
        int imageStartX = (this.getWidth() - imageWidth) / 2;
        g.setColor(this.background);
        g.drawImage(this.logo, imageStartX, this.borderWidth, imageStartX + imageWidth, this.borderWidth + imageHeight, 0, 0, this.logo.getWidth(), this.logo.getHeight(), this);
    }
}

