/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.CMapParser;
import org.verapdf.tools.StaticResources;

class CMapFactory {
    private static final Logger LOGGER = Logger.getLogger(CMapFactory.class.getCanonicalName());

    private CMapFactory() {
    }

    static CMap getCMap(String name, ASInputStream cMapStream) {
        CMap res = StaticResources.getCMap(name);
        if (res != null) {
            return res;
        }
        try {
            CMapParser parser = new CMapParser(cMapStream);
            parser.parse();
            res = parser.getCMap();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can't parse CMap " + name + ", using default", e);
            res = new CMap();
        }
        StaticResources.cacheCMap(name, res);
        return res;
    }
}

