/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdobeGlyphList {
    private static final Logger LOGGER = Logger.getLogger(AdobeGlyphList.class.getCanonicalName());
    private static final Map<String, AGLUnicode> MAPPING = new HashMap<String, AGLUnicode>();
    private static final String AGL_FILE = "/font/AdobeGlyphList.txt";
    private static final AGLUnicode EMPTY = new AGLUnicode(-1);

    public static AGLUnicode get(String glyphName) {
        AGLUnicode res = MAPPING.get(glyphName);
        if (res == null) {
            LOGGER.log(Level.FINE, "Cannot find glyph " + glyphName + " in Adobe Glyph List");
            return EMPTY;
        }
        return res;
    }

    public static boolean contains(String glyphName) {
        return MAPPING.containsKey(glyphName);
    }

    public static AGLUnicode empty() {
        return EMPTY;
    }

    static {
        try {
            File aglFile;
            Throwable throwable;
            boolean isTempFile = false;
            URL res = AdobeGlyphList.class.getResource(AGL_FILE);
            if (res.toString().startsWith("jar:")) {
                throwable = null;
                try (InputStream input = AdobeGlyphList.class.getResourceAsStream(AGL_FILE);){
                    int read;
                    aglFile = File.createTempFile("tempfile", ".tmp");
                    isTempFile = true;
                    FileOutputStream out = new FileOutputStream(aglFile);
                    byte[] bytes = new byte[1024];
                    while ((read = input.read(bytes)) != -1) {
                        ((OutputStream)out).write(bytes, 0, read);
                    }
                    aglFile.deleteOnExit();
                }
                catch (Throwable out) {
                    throwable = out;
                    throw out;
                }
            } else {
                aglFile = new File(res.getFile());
            }
            if (!aglFile.exists()) {
                throw new IOException("Error: File " + aglFile + " not found!");
            }
            throwable = null;
            try (RandomAccessFile stream = new RandomAccessFile(aglFile, "r");){
                String line = stream.readLine();
                do {
                    String[] words = line.split(" ");
                    int symbolCode = Integer.parseInt(words[1], 16);
                    if (words.length == 2) {
                        MAPPING.put(words[0], new AGLUnicode(symbolCode));
                        line = stream.readLine();
                        continue;
                    }
                    int[] diacritic = new int[words.length - 2];
                    for (int i = 0; i < diacritic.length; ++i) {
                        diacritic[i] = Integer.parseInt(words[i + 2], 16);
                    }
                    MAPPING.put(words[0], new AGLUnicode(symbolCode, diacritic));
                    line = stream.readLine();
                } while (line != null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            if (aglFile != null && isTempFile) {
                aglFile.delete();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error in opening Adobe Glyph List file", e);
        }
    }

    public static class AGLUnicode {
        private int symbolCode;
        private int[] diacriticCodes;

        AGLUnicode(int symbolCode, int ... diacriticCode) {
            this.symbolCode = symbolCode;
            this.diacriticCodes = diacriticCode;
        }

        AGLUnicode(int symbolCode) {
            this.symbolCode = symbolCode;
            this.diacriticCodes = new int[0];
        }

        public int getSymbolCode() {
            return this.symbolCode;
        }

        public int[] getDiacriticCodes() {
            return this.diacriticCodes;
        }

        public boolean hasDiacritic() {
            return this.diacriticCodes.length != 0;
        }

        public String getUnicodeString() {
            int[] res = new int[this.diacriticCodes.length + 1];
            res[0] = this.symbolCode;
            System.arraycopy(this.diacriticCodes, 0, res, 1, this.diacriticCodes.length);
            return new String(res, 0, res.length);
        }
    }
}

