/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.CIDToGIDMapping;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.truetype.BaseTrueTypeProgram;
import org.verapdf.pd.font.truetype.TrueTypeMaxpTable;

public class CIDFontType2Program
extends BaseTrueTypeProgram
implements FontProgram {
    private CMap cMap;
    private CIDToGIDMapping cidToGID;

    public CIDFontType2Program(ASInputStream stream, CMap cMap, COSObject cidToGID) throws IOException {
        super(stream);
        this.cMap = cMap;
        this.cidToGID = new CIDToGIDMapping(cidToGID);
    }

    @Override
    public float getWidth(int code) {
        int cid = this.cMap.toCID(code);
        return this.getWidthWithCheck(this.cidToGID.getGID(cid));
    }

    @Override
    public float getWidth(String glyphName) {
        return 0.0f;
    }

    @Override
    public boolean containsCode(int code) {
        int cid;
        if (this.cMap.containsCode(code) && this.cidToGID.contains(cid = this.cMap.toCID(code)) && cid != 0) {
            int gid = this.cidToGID.getGID(cid);
            TrueTypeMaxpTable maxpParser = this.parser.getMaxpParser();
            return maxpParser != null && gid < maxpParser.getNumGlyphs();
        }
        return false;
    }
}

