/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.validation.profiles.ErrorDetails;
import org.verapdf.pdfa.validation.profiles.ErrorDetailsImpl;
import org.verapdf.pdfa.validation.profiles.Reference;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.RuleIdImpl;

@XmlRootElement(name="rule")
final class RuleImpl
implements Rule {
    private static final RuleImpl DEFAULT = new RuleImpl();
    @XmlElement
    private final RuleId id;
    @XmlAttribute
    private final String object;
    @XmlElement
    private final String description;
    @XmlElement
    private final String test;
    @XmlElement
    private final ErrorDetails error;
    @XmlElementWrapper
    @XmlElement(name="reference")
    private final List<Reference> references = new ArrayList<Reference>();

    private RuleImpl() {
        this(RuleIdImpl.defaultInstance(), "object", "description", "test", ErrorDetailsImpl.defaultInstance(), Collections.emptyList());
    }

    private RuleImpl(RuleId id, String object, String description, String test, ErrorDetails error, List<Reference> references) {
        this.id = id;
        this.object = object;
        this.description = description;
        this.test = test;
        this.error = error;
        this.references.addAll(references);
    }

    @Override
    public RuleId getRuleId() {
        return this.id;
    }

    @Override
    public String getObject() {
        return this.object;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public ErrorDetails getError() {
        return this.error;
    }

    @Override
    public List<Reference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.references == null ? 0 : this.references.hashCode());
        result = 31 * result + (this.test == null ? 0 : this.test.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
            return false;
        }
        if (this.id == null ? other.getRuleId() != null : !this.id.equals(other.getRuleId())) {
            return false;
        }
        if (this.object == null ? other.getObject() != null : !this.object.equals(other.getObject())) {
            return false;
        }
        if (this.references == null ? other.getReferences() != null : !this.references.equals(other.getReferences())) {
            return false;
        }
        if (this.test == null ? other.getTest() != null : !this.test.equals(other.getTest())) {
            return false;
        }
        return !(this.error == null ? other.getError() != null : !this.error.equals(other.getError()));
    }

    public String toString() {
        return "Rule [id=" + this.id + ", object=" + this.object + ", description=" + this.description + ", test=" + this.test + ", error=" + this.error + ", references=" + this.references + "]";
    }

    static RuleImpl defaultInstance() {
        return DEFAULT;
    }

    static RuleImpl fromValues(RuleId id, String object, String description, String test, ErrorDetails error, List<Reference> references) {
        return new RuleImpl(RuleIdImpl.fromRuleId(id), object, description, test, error, references);
    }

    static RuleImpl fromRule(Rule toConvert) {
        return RuleImpl.fromValues(RuleIdImpl.fromRuleId(toConvert.getRuleId()), toConvert.getObject(), toConvert.getDescription(), toConvert.getTest(), toConvert.getError(), toConvert.getReferences());
    }

    static class Adapter
    extends XmlAdapter<RuleImpl, Rule> {
        Adapter() {
        }

        public Rule unmarshal(RuleImpl ruleImpl) {
            return ruleImpl;
        }

        public RuleImpl marshal(Rule rule) {
            return (RuleImpl)rule;
        }
    }
}

