/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.results.Location;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.profiles.Variable;

class BaseValidator
implements PDFAValidator {
    private static final URI componentId = URI.create("http://pdfa.verapdf.org/validators#default");
    private static final String componentName = "veraPDF PDF/A Validator";
    private static final ComponentDetails componentDetails = Components.libraryDetails(componentId, "veraPDF PDF/A Validator");
    private static final int OPTIMIZATION_LEVEL = 9;
    private final ValidationProfile profile;
    private Context context;
    private ScriptableObject scope;
    private final Deque<org.verapdf.model.baselayer.Object> objectsStack = new ArrayDeque<org.verapdf.model.baselayer.Object>();
    private final Deque<String> objectsContext = new ArrayDeque<String>();
    private final Deque<Set<String>> contextSet = new ArrayDeque<Set<String>>();
    protected final Set<TestAssertion> results = new HashSet<TestAssertion>();
    protected int testCounter = 0;
    protected boolean abortProcessing = false;
    protected final boolean logPassedTests;
    protected boolean isCompliant = true;
    private Map<RuleId, Script> ruleScripts = new HashMap<RuleId, Script>();
    private Map<String, Script> variableScripts = new HashMap<String, Script>();
    private Set<String> idSet = new HashSet<String>();
    protected String rootType;

    protected BaseValidator(ValidationProfile profile) {
        this(profile, false);
    }

    protected BaseValidator(ValidationProfile profile, boolean logPassedTests) {
        this.profile = profile;
        this.logPassedTests = logPassedTests;
    }

    @Override
    public ValidationProfile getProfile() {
        return this.profile;
    }

    @Override
    public ValidationResult validate(PDFAParser toValidate) throws ValidationException {
        try {
            return this.validate(toValidate.getRoot());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Caught unexpected runtime exception during validation", e);
        }
        catch (ModelParsingException excep) {
            throw new ValidationException("Parsing problem trying to validate.", excep);
        }
    }

    @Override
    public ComponentDetails getDetails() {
        return componentDetails;
    }

    protected ValidationResult validate(org.verapdf.model.baselayer.Object root) throws ValidationException {
        this.initialise();
        this.rootType = root.getObjectType();
        this.objectsStack.push(root);
        this.objectsContext.push("root");
        HashSet<String> rootIDContext = new HashSet<String>();
        if (root.getID() != null) {
            rootIDContext.add(root.getID());
            this.idSet.add(root.getID());
        }
        this.contextSet.push(rootIDContext);
        while (!this.objectsStack.isEmpty() && !this.abortProcessing) {
            this.checkNext();
        }
        Context.exit();
        ValidationResult res = ValidationResults.resultFromValues(this.profile.getPDFAFlavour(), this.profile.getDetails(), this.results, this.isCompliant, this.testCounter);
        return res;
    }

    protected void initialise() {
        this.context = Context.enter();
        this.context.setOptimizationLevel(9);
        this.scope = this.context.initStandardObjects();
        this.objectsStack.clear();
        this.objectsContext.clear();
        this.contextSet.clear();
        this.results.clear();
        this.idSet.clear();
        this.testCounter = 0;
        this.isCompliant = true;
        this.initializeAllVariables();
    }

    private void initializeAllVariables() {
        for (Variable var : this.profile.getVariables()) {
            if (var == null) continue;
            Object res = this.context.evaluateString(this.scope, var.getDefaultValue(), null, 0, null);
            if (res instanceof NativeJavaObject) {
                res = ((NativeJavaObject)res).unwrap();
            }
            this.scope.put(var.getName(), (Scriptable)this.scope, res);
        }
    }

    private boolean checkNext() throws ValidationException {
        org.verapdf.model.baselayer.Object checkObject = this.objectsStack.pop();
        String checkContext = this.objectsContext.pop();
        Set<String> checkIDContext = this.contextSet.pop();
        boolean res = this.checkAllRules(checkObject, checkContext);
        this.updateVariables(checkObject);
        this.addAllLinkedObjects(checkObject, checkContext, checkIDContext);
        return res;
    }

    private void updateVariables(org.verapdf.model.baselayer.Object object) {
        if (object != null) {
            this.updateVariableForObjectWithType(object, object.getObjectType());
            for (String parentName : object.getSuperTypes()) {
                this.updateVariableForObjectWithType(object, parentName);
            }
        }
    }

    private void updateVariableForObjectWithType(org.verapdf.model.baselayer.Object object, String objectType) {
        for (Variable var : this.profile.getVariablesByObject(objectType)) {
            if (var == null) continue;
            Object variable = this.evalVariableResult(var, object);
            this.scope.put(var.getName(), (Scriptable)this.scope, variable);
        }
    }

    private Object evalVariableResult(Variable variable, org.verapdf.model.baselayer.Object object) {
        Script script;
        if (!this.variableScripts.containsKey(variable.getName())) {
            String source = BaseValidator.getStringScript(object, variable.getValue());
            script = this.context.compileString(source, null, 0, null);
            this.variableScripts.put(variable.getName(), script);
        } else {
            script = this.variableScripts.get(variable.getName());
        }
        this.scope.put("obj", (Scriptable)this.scope, (Object)object);
        Object res = script.exec(this.context, this.scope);
        if (res instanceof NativeJavaObject) {
            res = ((NativeJavaObject)res).unwrap();
        }
        return res;
    }

    private void addAllLinkedObjects(org.verapdf.model.baselayer.Object checkObject, String checkContext, Set<String> checkIDContext) throws ValidationException {
        List<String> links = checkObject.getLinks();
        for (int j = links.size() - 1; j >= 0; --j) {
            String link = links.get(j);
            if (link == null) {
                throw new ValidationException("There is a null link name in an object. Context: " + checkContext);
            }
            List<? extends org.verapdf.model.baselayer.Object> objects = checkObject.getLinkedObjects(link);
            if (objects == null) {
                throw new ValidationException("There is a null link in an object. Context: " + checkContext);
            }
            for (int i = 0; i < objects.size(); ++i) {
                org.verapdf.model.baselayer.Object obj = objects.get(i);
                StringBuilder path = new StringBuilder(checkContext);
                path.append("/");
                path.append(link);
                path.append("[");
                path.append(i);
                path.append("]");
                if (obj == null) {
                    throw new ValidationException("There is a null link in an object. Context of the link: " + path);
                }
                if (!this.checkRequired(obj, checkIDContext)) continue;
                this.objectsStack.push(obj);
                HashSet<String> newCheckIDContext = new HashSet<String>(checkIDContext);
                if (obj.getID() != null) {
                    path.append("(");
                    path.append(obj.getID());
                    path.append(")");
                    newCheckIDContext.add(obj.getID());
                    this.idSet.add(obj.getID());
                }
                this.objectsContext.push(path.toString());
                this.contextSet.push(newCheckIDContext);
            }
        }
    }

    private boolean checkRequired(org.verapdf.model.baselayer.Object obj, Set<String> checkIDContext) {
        if (obj.getID() == null) {
            return true;
        }
        if (obj.isContextDependent().booleanValue()) {
            return !checkIDContext.contains(obj.getID());
        }
        return !this.idSet.contains(obj.getID());
    }

    private boolean checkAllRules(org.verapdf.model.baselayer.Object checkObject, String checkContext) {
        boolean res = true;
        Set<Rule> roolsForObject = this.profile.getRulesByObject(checkObject.getObjectType());
        for (Rule rule : roolsForObject) {
            res &= this.checkObjWithRule(checkObject, checkContext, rule);
        }
        for (String checkType : checkObject.getSuperTypes()) {
            roolsForObject = this.profile.getRulesByObject(checkType);
            if (roolsForObject == null) continue;
            for (Rule rule : roolsForObject) {
                if (rule == null) continue;
                res &= this.checkObjWithRule(checkObject, checkContext, rule);
            }
        }
        return res;
    }

    private static String getScript(org.verapdf.model.baselayer.Object obj, Rule rule) {
        return BaseValidator.getStringScript(obj, "(" + rule.getTest() + ")==true");
    }

    private static String getStringScript(org.verapdf.model.baselayer.Object obj, String arg) {
        return BaseValidator.getScriptPrefix(obj, arg) + arg + BaseValidator.getScriptSuffix();
    }

    private static String getScriptPrefix(org.verapdf.model.baselayer.Object obj, String test) {
        StringBuilder builder = new StringBuilder();
        String[] vars = test.split("\\W");
        for (String prop : obj.getProperties()) {
            if (!BaseValidator.contains(vars, prop)) continue;
            builder.append("var ");
            builder.append(prop);
            builder.append(" = obj.get");
            builder.append(prop);
            builder.append("();\n");
        }
        for (String linkName : obj.getLinks()) {
            if (!BaseValidator.contains(vars, linkName + "_size")) continue;
            builder.append("var ");
            builder.append(linkName);
            builder.append("_size = obj.getLinkedObjects(\"");
            builder.append(linkName);
            builder.append("\").size();\n");
        }
        builder.append("function test(){return ");
        return builder.toString();
    }

    private static boolean contains(String[] values, String prop) {
        for (String value : values) {
            if (!value.equals(prop)) continue;
            return true;
        }
        return false;
    }

    private static String getScriptSuffix() {
        return ";}\ntest();";
    }

    private boolean checkObjWithRule(org.verapdf.model.baselayer.Object obj, String cntxtForRule, Rule rule) {
        Script scr;
        this.scope.put("obj", (Scriptable)this.scope, (Object)obj);
        if (!this.ruleScripts.containsKey(rule.getRuleId())) {
            scr = this.context.compileString(BaseValidator.getScript(obj, rule), null, 0, null);
            this.ruleScripts.put(rule.getRuleId(), scr);
        } else {
            scr = this.ruleScripts.get(rule.getRuleId());
        }
        boolean testEvalResult = (Boolean)scr.exec(this.context, this.scope);
        this.processAssertionResult(testEvalResult, cntxtForRule, rule);
        return testEvalResult;
    }

    protected void processAssertionResult(boolean assertionResult, String locationContext, Rule rule) {
        ++this.testCounter;
        Location location = ValidationResults.locationFromValues(this.rootType, locationContext);
        TestAssertion assertion = ValidationResults.assertionFromValues(this.testCounter, rule.getRuleId(), assertionResult ? TestAssertion.Status.PASSED : TestAssertion.Status.FAILED, rule.getDescription(), location);
        if (this.isCompliant) {
            this.isCompliant = assertionResult;
        }
        if (!assertionResult || this.logPassedTests) {
            this.results.add(assertion);
        }
    }

    @Override
    public void close() {
    }
}

