/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.policy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

final class SchematronPipeline {
    static final ClassLoader cl = SchematronPipeline.class.getClassLoader();
    private static final TransformerFactory factory = SchematronPipeline.getTransformerFactory();
    private static final String xslExt = ".xsl";
    private static final String resourcePath = "org/verapdf/policy/schematron/pipeline/";
    private static final String isoDsdlXsl = "org/verapdf/policy/schematron/pipeline/iso_dsdl_include.xsl";
    private static final String isoExpXsl = "org/verapdf/policy/schematron/pipeline/iso_abstract_expand.xsl";
    private static final String isoSvrlXsl = "org/verapdf/policy/schematron/pipeline/iso_svrl_for_xslt1.xsl";
    private static final Templates cachedIsoDsdXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/schematron/pipeline/iso_dsdl_include.xsl");
    private static final Templates cachedExpXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/schematron/pipeline/iso_abstract_expand.xsl");
    private static final Templates cachedIsoSvrlXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/schematron/pipeline/iso_svrl_for_xslt1.xsl");

    private SchematronPipeline() {
    }

    public static void processSchematron(InputStream schematronSource, OutputStream xslDest) throws TransformerException, IOException {
        File isoDsdResult = SchematronPipeline.createTempFileResult(cachedIsoDsdXsl.newTransformer(), new StreamSource(schematronSource), "IsoDsd");
        File isoExpResult = SchematronPipeline.createTempFileResult(cachedExpXsl.newTransformer(), new StreamSource(isoDsdResult), "ExpXsl");
        cachedIsoSvrlXsl.newTransformer().transform(new StreamSource(isoExpResult), new StreamResult(xslDest));
        isoDsdResult.delete();
        isoExpResult.delete();
    }

    static Templates createCachedTransform(String transName) {
        try {
            return factory.newTemplates(new StreamSource(cl.getResourceAsStream(transName)));
        }
        catch (TransformerConfigurationException excep) {
            throw new IllegalStateException("Policy Schematron transformer XSL " + transName + " not found.", excep);
        }
    }

    private static File createTempFileResult(Transformer transformer, StreamSource toTransform, String suffix) throws TransformerException, IOException {
        File result = File.createTempFile("veraPDF_", suffix);
        result.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(result);){
            transformer.transform(toTransform, new StreamResult(fos));
        }
        return result;
    }

    private static TransformerFactory getTransformerFactory() {
        TransformerFactory fact = TransformerFactory.newInstance();
        fact.setURIResolver(new ClasspathResourceURIResolver());
        return fact;
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(cl.getResourceAsStream(SchematronPipeline.resourcePath + href));
        }
    }
}

