/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.AuditDurationImpl;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.AbstractXmlHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.MetadataFixerReport;
import org.verapdf.processor.reports.Reports;
import org.verapdf.processor.reports.ValidationDetails;
import org.verapdf.processor.reports.ValidationReport;
import org.verapdf.report.FeaturesReport;

final class MrrHandler
extends AbstractXmlHandler {
    private static final String STATEMENT_PREFIX = "PDF file is ";
    private static final String NOT_INSERT = "not ";
    private static final String STATEMENT_SUFFIX = "compliant with Validation Profile requirements.";
    private static final String COMPLIANT_STATEMENT = "PDF file is compliant with Validation Profile requirements.";
    private static final String NONCOMPLIANT_STATEMENT = "PDF file is not compliant with Validation Profile requirements.";
    private static final String report = "report";
    private static final String jobEleName = "job";
    private static final String jobsEleName = "jobs";
    private static final String procTimeEleName = "processingTime";
    private static final String buildInfoEleName = "buildInformation";
    private static final String itemDetailsEleName = "itemDetails";
    private static final String releaseDetailsEleName = "releaseDetails";
    private static final String taskResultEleName = "taskResult";
    private static final String batchSummaryEleName = "batchSummary";
    private static final String fixerRepEleName = "fixerReport";
    private static final String featuresRepEleName = "featuresReport";
    private static final String validationRepEleName = "validationReport";
    private final int maxFailedChecks;
    private final boolean logPassed;

    private MrrHandler(Writer dest) throws VeraPDFException {
        this(dest, 100, false);
    }

    private MrrHandler(Writer dest, int maxFailedChecks, boolean logPassed) throws VeraPDFException {
        super(dest);
        this.maxFailedChecks = maxFailedChecks;
        this.logPassed = logPassed;
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) throws VeraPDFException {
        try {
            MrrHandler.startDoc(this.writer);
            this.writer.writeStartElement(report);
            this.addReleaseDetails();
            this.writer.writeStartElement(jobsEleName);
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    private void addReleaseDetails() throws XMLStreamException, VeraPDFException {
        this.writer.writeStartElement(buildInfoEleName);
        for (ReleaseDetails details : ReleaseDetails.getDetails()) {
            this.serialseElement(details, releaseDetailsEleName, true, true);
        }
        this.writer.writeEndElement();
    }

    @Override
    void resultStart(ProcessorResult result) throws VeraPDFException {
        try {
            this.writer.writeStartElement(jobEleName);
            this.serialseElement(result.getProcessedItem(), itemDetailsEleName, true, true);
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        this.serialseElement(taskResult, taskResultEleName, true, true);
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        this.serialseElement(taskResult, taskResultEleName, true, true);
    }

    @Override
    void validationSuccess(TaskResult taskResult, ValidationResult result) throws VeraPDFException {
        ValidationDetails details = Reports.fromValues(result, this.logPassed, this.maxFailedChecks);
        ValidationReport valRep = Reports.createValidationReport(details, result.getProfileDetails().getName(), MrrHandler.getStatement(result.isCompliant()), result.isCompliant());
        this.serialseElement(valRep, validationRepEleName, true, true);
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        this.serialseElement(taskResult, taskResultEleName, true, true);
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featRep) throws VeraPDFException {
        this.serialseElement(featRep, featuresRepEleName, true, true);
    }

    @Override
    void featureFailure(TaskResult taskResult) throws VeraPDFException {
        this.serialseElement(taskResult, taskResultEleName, true, true);
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) throws VeraPDFException {
        MetadataFixerReport mfRep = Reports.fromValues(fixerResult);
        this.serialseElement(mfRep, fixerRepEleName, true, true);
    }

    @Override
    void fixerFailure(TaskResult taskResult) throws VeraPDFException {
        this.serialseElement(taskResult, taskResultEleName, true, true);
    }

    @Override
    void resultEnd(ProcessorResult result) throws VeraPDFException {
        AuditDuration duration = AuditDurationImpl.sumDuration(MrrHandler.getDurations(result));
        this.serialseElement(duration, procTimeEleName, true, true);
        try {
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        try {
            this.writer.writeEndElement();
            this.serialseElement(summary, batchSummaryEleName, true, true);
            MrrHandler.newLine(this.writer);
            this.writer.writeEndElement();
            this.writer.flush();
            MrrHandler.endDoc(this.writer);
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
        this.close();
    }

    private static Collection<AuditDuration> getDurations(ProcessorResult result) {
        EnumMap<TaskType, TaskResult> results = result.getResults();
        if (results != null) {
            ArrayList<AuditDuration> res = new ArrayList<AuditDuration>();
            for (TaskType type : results.keySet()) {
                if (results.get((Object)type).getDuration() == null) continue;
                res.add(results.get((Object)type).getDuration());
            }
            return res;
        }
        return Collections.emptyList();
    }

    protected static VeraPDFException wrapStreamException(JAXBException excep, String typePart) {
        return new VeraPDFException(String.format("Unmarshalling exception when streaming %s.", typePart), excep);
    }

    static BatchProcessingHandler newInstance(Writer dest, boolean logPassed, int maxFailedChecks) throws VeraPDFException {
        return new MrrHandler(dest, maxFailedChecks, logPassed);
    }

    private static String getStatement(boolean status) {
        return status ? COMPLIANT_STATEMENT : NONCOMPLIANT_STATEMENT;
    }
}

