/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.verapdf.tools.RC4Encryption;

public class EncryptionTools {
    private static final int PADDED_PASSWORD_LENGTH = 32;
    private static final int AMOUNT_OF_REPEATS_MD5 = 50;
    private static final int AMOUNT_OF_REPEATS_RC4 = 19;
    private static final int U_LENGTH = 16;
    private static final byte[] DEFAULT_PADDING_STRING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] FF_STRING = new byte[]{-1, -1, -1, -1};

    private EncryptionTools() {
    }

    public static byte[] computeEncryptionKey(String password, byte[] o, int p, byte[] id, int revision, boolean metadataIsEncrypted, int length) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(EncryptionTools.getPaddedPassword(password));
        md5.update(o);
        md5.update(EncryptionTools.intToBytesLowOrderFirst(p));
        md5.update(id);
        if (revision >= 4 && !metadataIsEncrypted) {
            md5.update(FF_STRING);
        }
        byte[] res = md5.digest();
        if (revision >= 3) {
            for (int i = 0; i < 50; ++i) {
                md5.reset();
                md5.update(Arrays.copyOf(res, length / 8));
                res = md5.digest();
            }
        }
        return Arrays.copyOf(res, length / 8);
    }

    public static byte[] computeOValue(String ownerPassword, int revision, int length, String userPassword) throws NoSuchAlgorithmException {
        if (ownerPassword == null) {
            ownerPassword = userPassword;
        }
        byte[] password = EncryptionTools.getPaddedPassword(ownerPassword);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(password);
        password = md5.digest();
        if (revision >= 3) {
            for (int i = 0; i < 50; ++i) {
                md5.reset();
                md5.update(password);
                password = md5.digest();
            }
        }
        int actualLength = revision >= 3 ? length / 8 : 5;
        RC4Encryption rc4 = new RC4Encryption(Arrays.copyOf(password, actualLength));
        byte[] rc4Result = rc4.process(EncryptionTools.getPaddedPassword(ownerPassword));
        if (revision >= 3) {
            for (int i = 1; i <= 19; ++i) {
                rc4 = new RC4Encryption(EncryptionTools.modifyEncryptionKeyWithCounter(Arrays.copyOf(password, actualLength), i));
                rc4Result = rc4.process(rc4Result);
            }
        }
        return rc4Result;
    }

    public static byte[] computeUValue(String password, byte[] o, int p, byte[] id, int revision, boolean metadataIsEncrypted, int length) throws NoSuchAlgorithmException {
        if (revision == 2) {
            return EncryptionTools.computeUValueRevision2(password, o, p, id, metadataIsEncrypted, length);
        }
        byte[] key = EncryptionTools.computeEncryptionKey(password, o, p, id, revision, metadataIsEncrypted, length);
        RC4Encryption rc4 = new RC4Encryption(key);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(DEFAULT_PADDING_STRING);
        md5.update(id);
        byte[] md5Result = md5.digest();
        byte[] rc4Result = rc4.process(md5Result);
        for (int i = 1; i <= 19; ++i) {
            rc4 = new RC4Encryption(EncryptionTools.modifyEncryptionKeyWithCounter(key, i));
            rc4Result = rc4.process(rc4Result);
        }
        return rc4Result;
    }

    public static byte[] authenticateUserPassword(String password, byte[] o, int p, byte[] id, int revision, boolean metadataIsEncrypted, int length, byte[] u) throws NoSuchAlgorithmException {
        byte[] uValue = EncryptionTools.computeUValue(password, o, p, id, revision, metadataIsEncrypted, length);
        if (revision >= 3) {
            u = Arrays.copyOf(u, 16);
        }
        if (Arrays.equals(u, uValue)) {
            return EncryptionTools.computeEncryptionKey(password, o, p, id, revision, metadataIsEncrypted, length);
        }
        return null;
    }

    private static byte[] computeUValueRevision2(String password, byte[] o, int p, byte[] id, boolean metadataIsEncrypted, int length) throws NoSuchAlgorithmException {
        byte[] key = EncryptionTools.computeEncryptionKey(password, o, p, id, 2, metadataIsEncrypted, length);
        RC4Encryption rc4 = new RC4Encryption(key);
        return rc4.process(DEFAULT_PADDING_STRING);
    }

    private static byte[] getPaddedPassword(String password) {
        byte[] psw;
        if (password == null) {
            password = "";
        }
        try {
            psw = password.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            psw = password.getBytes();
        }
        byte[] res = new byte[32];
        if (psw.length > 32) {
            System.arraycopy(psw, 0, res, 0, 32);
        } else {
            System.arraycopy(psw, 0, res, 0, psw.length);
            for (int i = 0; i < 32 - psw.length; ++i) {
                res[i + psw.length] = DEFAULT_PADDING_STRING[i];
            }
        }
        return res;
    }

    public static byte[] intToBytesLowOrderFirst(long p) {
        byte[] res = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byte b = (byte)(p & 0xFFL);
            p >>= 8;
            res[i] = b;
        }
        return res;
    }

    private static byte[] modifyEncryptionKeyWithCounter(byte[] key, int counter) {
        byte[] res = new byte[key.length];
        for (int i = 0; i < key.length; ++i) {
            res[i] = (byte)(key[i] ^ counter);
        }
        return res;
    }
}

