/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class PDNonTerminalField
extends PDField {
    public PDNonTerminalField(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDNonTerminalField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    @Override
    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.dictionary.getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    @Override
    void importFDF(FDFField fdfField) throws IOException {
        super.importFDF(fdfField);
        List<FDFField> fdfKids = fdfField.getKids();
        List<PDField> children = this.getChildren();
        for (int i = 0; fdfKids != null && i < fdfKids.size(); ++i) {
            for (COSObjectable cOSObjectable : children) {
                if (!(cOSObjectable instanceof PDField)) continue;
                PDField pdChild = (PDField)cOSObjectable;
                FDFField fdfChild = fdfKids.get(i);
                String fdfName = fdfChild.getPartialFieldName();
                if (fdfName == null || !fdfName.equals(pdChild.getPartialName())) continue;
                pdChild.importFDF(fdfChild);
            }
        }
    }

    @Override
    FDFField exportFDF() throws IOException {
        FDFField fdfField = new FDFField();
        fdfField.setPartialFieldName(this.getPartialName());
        fdfField.setValue(this.getValue());
        List<PDField> children = this.getChildren();
        ArrayList<FDFField> fdfChildren = new ArrayList<FDFField>();
        for (PDField child : children) {
            fdfChildren.add(child.exportFDF());
        }
        fdfField.setKids(fdfChildren);
        return fdfField;
    }

    public List<PDField> getChildren() {
        ArrayList<PDField> children = new ArrayList<PDField>();
        COSArray kids = (COSArray)this.dictionary.getDictionaryObject(COSName.KIDS);
        for (int i = 0; i < kids.size(); ++i) {
            PDField field = PDField.fromDictionary(this.acroForm, (COSDictionary)kids.getObject(i), this);
            children.add(field);
        }
        return children;
    }

    public void setChildren(List<PDField> children) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(children);
        this.dictionary.setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    @Override
    public String getFieldType() {
        return this.dictionary.getNameAsString(COSName.FT);
    }

    public COSBase getValue() {
        return this.dictionary.getDictionaryObject(COSName.V);
    }

    @Override
    public String getValueAsString() {
        return this.dictionary.getDictionaryObject(COSName.V).toString();
    }

    public void setValue(COSBase object) throws IOException {
        this.dictionary.setItem(COSName.V, object);
    }

    public COSBase getDefaultValue() {
        return this.dictionary.getDictionaryObject(COSName.DV);
    }

    public void setDefaultValue(COSBase value) {
        this.dictionary.setItem(COSName.V, value);
    }
}

