/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class PageTreeValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PDDocumentCatalog catalog = context.getDocument().getDocumentCatalog();
        if (catalog != null) {
            int numPages = context.getDocument().getNumberOfPages();
            for (int i = 0; i < numPages; ++i) {
                context.setCurrentPageNumber(i);
                this.validatePage(context, context.getDocument().getPage(i));
                context.setCurrentPageNumber(null);
            }
        } else {
            context.addValidationError(new ValidationResult.ValidationError("1.2.14", "There are no Catalog entry in the Document"));
        }
    }

    protected void validatePage(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page, "page-process");
    }
}

