/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.util.DateConverter;

public final class XMPChecker {
    private static final Logger LOGGER = Logger.getLogger(XMPChecker.class);
    private static final String TITLE = "Title";
    private static final String SUBJECT = "Subject";
    private static final String AUTHOR = "Author";
    private static final String KEYWORDS = "Keywords";
    private static final String PRODUCER = "Producer";
    private static final String CREATOR = "Creator";
    private static final String CREATION_DATE = "CreationDate";
    private static final String MODIFICATION_DATE = "ModDate";
    private static final int MAX_REQUIRED_RECORDS = 8;

    private XMPChecker() {
    }

    public static Boolean doesInfoMatchXMP(COSDocument document) {
        COSDictionary info = XMPChecker.getInformationDictionary(document);
        if (info == null) {
            return Boolean.TRUE;
        }
        try {
            COSStream meta = XMPChecker.getMetadataDictionary(document);
            if (meta != null) {
                VeraPDFMeta metadata = VeraPDFMeta.parse(meta.getUnfilteredStream());
                HashMap<String, Object> properties = new HashMap<String, Object>(8);
                XMPChecker.getTitleAuthorSubject(metadata, properties);
                XMPChecker.getProducerKeywords(metadata, properties);
                XMPChecker.getCreatorAndDates(metadata, properties);
                return XMPChecker.checkMatch(info, properties);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Problems with document parsing or structure. " + e.getMessage(), e);
        }
        catch (XMPException e) {
            LOGGER.debug("Problems with XMP parsing. " + e.getMessage(), e);
        }
        return Boolean.FALSE;
    }

    private static COSStream getMetadataDictionary(COSDocument document) throws IOException {
        COSDictionary catalog = (COSDictionary)document.getCatalog().getObject();
        COSObject metaObj = (COSObject)catalog.getItem(COSName.METADATA);
        if (metaObj != null && metaObj.getObject() instanceof COSStream) {
            return (COSStream)metaObj.getObject();
        }
        return null;
    }

    private static COSDictionary getInformationDictionary(COSDocument document) {
        COSObject info = (COSObject)document.getTrailer().getItem(COSName.INFO);
        if (info != null) {
            if (info.getObject() instanceof COSDictionary) {
                return (COSDictionary)info.getObject();
            }
            if (info.getObject() instanceof COSObject) {
                return XMPChecker.getInformationDictionary((COSObject)info.getObject());
            }
        }
        return null;
    }

    private static COSDictionary getInformationDictionary(COSObject object) {
        if (object.getObject() instanceof COSDictionary) {
            return (COSDictionary)object.getObject();
        }
        if (object.getObject() instanceof COSObject) {
            return XMPChecker.getInformationDictionary((COSObject)object.getObject());
        }
        return null;
    }

    private static void getTitleAuthorSubject(VeraPDFMeta metadata, Map<String, Object> properties) throws XMPException {
        XMPChecker.putProperty(properties, TITLE, metadata.getTitle());
        XMPChecker.putProperty(properties, SUBJECT, metadata.getDescription());
        List<String> buffer = metadata.getCreator();
        if (buffer != null) {
            XMPChecker.putProperty(properties, AUTHOR, buffer);
        }
    }

    private static void getProducerKeywords(VeraPDFMeta metadata, Map<String, Object> properties) throws XMPException {
        XMPChecker.putProperty(properties, KEYWORDS, metadata.getKeywords());
        XMPChecker.putProperty(properties, PRODUCER, metadata.getProducer());
    }

    private static void getCreatorAndDates(VeraPDFMeta metadata, Map<String, Object> properties) throws XMPException {
        XMPChecker.putProperty(properties, CREATOR, metadata.getCreatorTool());
        XMPChecker.putProperty(properties, CREATION_DATE, metadata.getCreateDate());
        XMPChecker.putProperty(properties, MODIFICATION_DATE, metadata.getModifyDate());
    }

    private static void putProperty(Map<String, Object> properties, String key, Object value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    private static Boolean checkMatch(COSDictionary info, Map<String, Object> properties) {
        boolean isAdobePDFMatch;
        boolean isDublinCoreMatch;
        boolean bl = isDublinCoreMatch = XMPChecker.checkProperty(info, properties, TITLE) != false && XMPChecker.checkProperty(info, properties, SUBJECT) != false && XMPChecker.checkProperty(info, properties, AUTHOR) != false;
        if (!isDublinCoreMatch) {
            return Boolean.FALSE;
        }
        boolean bl2 = isAdobePDFMatch = XMPChecker.checkProperty(info, properties, KEYWORDS) != false && XMPChecker.checkProperty(info, properties, PRODUCER) != false;
        if (!isAdobePDFMatch) {
            return Boolean.FALSE;
        }
        boolean isXMPBasicMatch = XMPChecker.checkProperty(info, properties, CREATOR) != false && XMPChecker.checkProperty(info, properties, CREATION_DATE) != false && XMPChecker.checkProperty(info, properties, MODIFICATION_DATE) != false;
        return isXMPBasicMatch;
    }

    private static Boolean checkProperty(COSDictionary info, Map<String, Object> properties, String checksRule) {
        COSBase item = info.getItem(checksRule);
        if (item == null || item instanceof COSNull) {
            return Boolean.TRUE;
        }
        if (item instanceof COSString) {
            return XMPChecker.checkCOSStringProperty((COSString)item, properties, checksRule);
        }
        if (item instanceof COSObject) {
            return XMPChecker.deepPropertyCheck((COSObject)item, properties, checksRule);
        }
        return Boolean.FALSE;
    }

    private static Boolean deepPropertyCheck(COSObject item, Map<String, Object> properties, String checksRule) {
        COSBase external = item.getObject();
        if (external == null || external instanceof COSNull) {
            return Boolean.TRUE;
        }
        if (external instanceof COSString) {
            return XMPChecker.checkCOSStringProperty((COSString)external, properties, checksRule);
        }
        if (external instanceof COSObject) {
            return XMPChecker.deepPropertyCheck((COSObject)external, properties, checksRule);
        }
        return Boolean.FALSE;
    }

    private static Boolean checkCOSStringProperty(COSString string, Map<String, Object> properties, String checksRule) {
        Object value = properties.get(checksRule);
        if (value != null) {
            if (value instanceof String) {
                return value.equals(string.getString());
            }
            if (value instanceof List) {
                List list = (List)value;
                return list.size() == 1 && list.get(0).equals(string.getString());
            }
            if (value instanceof Calendar) {
                String regex = "(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])";
                String ascii = string.getASCII();
                if (ascii.matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])")) {
                    Calendar valueDate = XMPChecker.getCalendar(ascii);
                    return valueDate != null && valueDate.compareTo((Calendar)value) == 0;
                }
                LOGGER.debug("Date format in info dictionary is not complies pdf date format");
            }
        }
        return Boolean.FALSE;
    }

    private static Calendar getCalendar(String date) {
        Matcher matcher = Pattern.compile("((([+-](\\d\\d[']))(\\d\\d['])?)|[Z])").matcher(date);
        return DateConverter.toCalendar(date, matcher.find());
    }
}

