/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as;

public class CharTable {
    private static final byte SPACE = 1;
    private static final byte DELIMITER = 2;
    private static final byte NUMERIC = 4;
    private static final byte OCTALDIGIT = 8;
    private static final byte[] charAttributes = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 4, 0, 2, 0, 0, 2, 2, 0, 4, 0, 4, 4, 2, 12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte ASCII_NUL = 0;
    public static final byte ASCII_BS = 8;
    public static final byte ASCII_HT = 9;
    public static final byte ASCII_LF = 10;
    public static final byte ASCII_FF = 12;
    public static final byte ASCII_CR = 13;
    public static final byte ASCII_SPACE = 32;
    public static final byte ASCII_ZERO = 48;
    public static final byte ASCII_NINE = 57;
    public static final byte ASCII_LEFT_PAR = 40;
    public static final byte ASCII_RIGHT_PAR = 41;

    public static byte getAttributes(int c) {
        return charAttributes[c];
    }

    public static boolean isSpace(int c) {
        if (c < 0 || c > 255) {
            return false;
        }
        return (CharTable.getAttributes(c) & 1) != 0;
    }

    public static boolean isTokenDelimiter(int c) {
        if (c < 0 || c > 255) {
            return false;
        }
        return (CharTable.getAttributes(c) & 3) != 0;
    }

    public static boolean isRegular(int c) {
        if (c < 0 || c > 255) {
            return false;
        }
        return (CharTable.getAttributes(c) & 3) == 0;
    }
}

