/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp;

import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.XMPConstants;

public class ValidatorsContainerCreator {
    private static ValidatorsContainer PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1 = null;
    private static ValidatorsContainer PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3 = null;
    private static ValidatorsContainer PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_1 = null;
    private static ValidatorsContainer PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_2_3 = null;

    static ValidatorsContainer getPredefinedContainerForPDFA_1(boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            if (PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_1 == null) {
                PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_1 = ValidatorsContainerCreator.createValidatorsContainerPredefinedForPDFA_1(true);
            }
            return PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_1;
        }
        if (PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1 == null) {
            PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1 = ValidatorsContainerCreator.createValidatorsContainerPredefinedForPDFA_1(false);
        }
        return PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_1;
    }

    static ValidatorsContainer getPredefinedContainerForPDFA_2_3(boolean isClosedFieldsCheck) {
        if (isClosedFieldsCheck) {
            if (PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_2_3 == null) {
                PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_2_3 = ValidatorsContainerCreator.createValidatorsContainerPredefinedForPDFA_2_3(true);
            }
            return PREDEFINED_CONTAINER_WITH_CLOSED_CHOICE_FOR_PDFA_2_3;
        }
        if (PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3 == null) {
            PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3 = ValidatorsContainerCreator.createValidatorsContainerPredefinedForPDFA_2_3(false);
        }
        return PREDEFINED_CONTAINER_WITHOUT_CLOSED_CHOICE_FOR_PDFA_2_3;
    }

    private static ValidatorsContainer createValidatorsContainerPredefinedForPDFA_1(boolean isClosedFieldsCheck) {
        ValidatorsContainer container = ValidatorsContainerCreator.createBasicValidatorsContainer(isClosedFieldsCheck);
        container.registerSimpleValidator("gpscoordinate", Pattern.compile("^\\d{2},\\d{2}[,\\.]\\d{2}[NSEW]$"));
        container.registerSimpleValidator("locale", Pattern.compile("^([a-zA-Z]{1,8})((-[a-zA-Z]{1,8})*)$"));
        return container;
    }

    private static ValidatorsContainer createValidatorsContainerPredefinedForPDFA_2_3(boolean isClosedFieldsCheck) {
        ValidatorsContainer container = ValidatorsContainerCreator.createBasicValidatorsContainer(isClosedFieldsCheck);
        container.registerSimpleValidator("gpscoordinate", Pattern.compile("^\\d{1,3},\\d{1,2}(,\\d{1,2}|\\.\\d+)[NSEW]$"));
        container.registerSimpleValidator("locale", Pattern.compile("^([a-zA-Z]{1,8})((-[a-zA-Z0-9]{1,8})*)$"));
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("colorant", isClosedFieldsCheck, XMPConstants.getColorantWithoutRestrictedFieldStructure(), XMPConstants.getColorantRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("font", XMPConstants.getFontStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("beatsplicestretch", XMPConstants.getBeatSpliceStretchStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("marker", isClosedFieldsCheck, XMPConstants.getMarkerWithoutRestrictedFieldStructure(), XMPConstants.getMarkerRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("media", XMPConstants.getMediaStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("projectlink", isClosedFieldsCheck, XMPConstants.getProjectLinkWithoutRestrictedFieldStructure(), XMPConstants.getProjectLinkRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("resamplestretch", isClosedFieldsCheck, XMPConstants.getResampleStretchWithoutRestrictedFieldStructure(), XMPConstants.getResampleStretchRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("time", XMPConstants.getTimeStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("timecode", isClosedFieldsCheck, XMPConstants.getTimecodeWithoutRestrictedFieldStructure(), XMPConstants.getTimecodeRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("timescalestretch", isClosedFieldsCheck, XMPConstants.getTimeScaleStretchWithoutRestrictedFieldStructure(), XMPConstants.getTimeScaleStretchRestrictedFieldStructure(), container);
        return container;
    }

    private static ValidatorsContainer createBasicValidatorsContainer(boolean isClosedFieldsCheck) {
        ValidatorsContainer container = new ValidatorsContainer();
        ValidatorsContainerCreator.registerStructureTypeForContainer("dimensions", XMPConstants.getDimensionsStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("thumbnail", isClosedFieldsCheck, XMPConstants.getThumbnailWithoutRestrictedFieldStructure(), XMPConstants.getThumbnailRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("resourceevent", XMPConstants.getResourceEventStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("resourceref", XMPConstants.getResourceRefStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("version", XMPConstants.getVersionStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("job", XMPConstants.getJobStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeWithRestrictedSimpleFieldsForContainer("flash", isClosedFieldsCheck, XMPConstants.getFlashWithoutRestrictedFieldStructure(), XMPConstants.getFlashRestrictedFieldStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("oecf/sfr", XMPConstants.getOecfSfrStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("cfapattern", XMPConstants.getCfaPatternStructure(), container);
        ValidatorsContainerCreator.registerStructureTypeForContainer("devicesettings", XMPConstants.getDeviceSettingsStructure(), container);
        return container;
    }

    static ValidatorsContainer createExtendedValidatorsContainerForPDFA_1(VeraPDFXMPNode extensionContainer, boolean isClosedFieldsCheck) {
        ValidatorsContainer container = ValidatorsContainerCreator.createValidatorsContainerPredefinedForPDFA_1(isClosedFieldsCheck);
        return ValidatorsContainerCreator.createExtendedValidatorsContainer(extensionContainer, container);
    }

    static ValidatorsContainer createExtendedValidatorsContainerForPDFA_2_3(VeraPDFXMPNode extensionContainer, boolean isClosedFieldsCheck) {
        ValidatorsContainer container = ValidatorsContainerCreator.createValidatorsContainerPredefinedForPDFA_2_3(isClosedFieldsCheck);
        return ValidatorsContainerCreator.createExtendedValidatorsContainer(extensionContainer, container);
    }

    private static ValidatorsContainer createExtendedValidatorsContainer(VeraPDFXMPNode schemasDefinitions, ValidatorsContainer container) {
        List<VeraPDFXMPNode> schemas = schemasDefinitions.getChildren();
        for (VeraPDFXMPNode node : schemas) {
            ValidatorsContainerCreator.registerAllTypesFromExtensionSchemaNode(node, container);
        }
        return container;
    }

    private static void registerAllTypesFromExtensionSchemaNode(VeraPDFXMPNode schema, ValidatorsContainer container) {
        List<VeraPDFXMPNode> schemaChildren = schema.getChildren();
        for (int i = schemaChildren.size() - 1; i >= 0; --i) {
            VeraPDFXMPNode child = schemaChildren.get(i);
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !"valueType".equals(child.getName())) continue;
            if (!child.getOptions().isArray()) break;
            ValidatorsContainerCreator.registerAllTypesFromValueTypeArrayNode(child, container);
            break;
        }
    }

    private static void registerAllTypesFromValueTypeArrayNode(VeraPDFXMPNode valueTypes, ValidatorsContainer container) {
        List<VeraPDFXMPNode> children = valueTypes.getChildren();
        for (VeraPDFXMPNode node : children) {
            ValidatorsContainerCreator.registerTypeNode(node, container);
        }
    }

    private static void registerTypeNode(VeraPDFXMPNode valueType, ValidatorsContainer container) {
        String name = null;
        String namespace = null;
        Map<String, String> fields = null;
        for (VeraPDFXMPNode child : valueType.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI())) continue;
            switch (child.getName()) {
                case "type": {
                    name = child.getValue();
                    break;
                }
                case "namespaceURI": {
                    namespace = child.getValue();
                    break;
                }
                case "field": {
                    if (!child.getOptions().isArray()) break;
                    fields = ValidatorsContainerCreator.getStructureMapFromFieldsNode(child);
                    break;
                }
            }
        }
        if (name != null && namespace != null && fields != null && !fields.isEmpty()) {
            container.registerStructuredValidator(name, namespace, fields);
        }
    }

    private static Map<String, String> getStructureMapFromFieldsNode(VeraPDFXMPNode node) {
        HashMap<String, String> res = new HashMap<String, String>();
        List<VeraPDFXMPNode> fields = node.getChildren();
        for (VeraPDFXMPNode field : fields) {
            String name = null;
            String valueType = null;
            for (VeraPDFXMPNode child : field.getChildren()) {
                if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI())) continue;
                switch (child.getName()) {
                    case "name": {
                        name = child.getValue();
                        break;
                    }
                    case "valueType": {
                        valueType = child.getValue();
                        break;
                    }
                }
            }
            if (name == null || valueType == null) continue;
            res.put(name, valueType);
        }
        return res;
    }

    private static void registerStructureTypeForContainer(String structureType, String[] structure, ValidatorsContainer container) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (int i = 1; i < structure.length; i += 2) {
            res.put(structure[i], structure[i + 1]);
        }
        container.registerStructuredValidator(structureType, structure[0], res);
    }

    private static void registerStructureTypeWithRestrictedSimpleFieldsForContainer(String structureType, boolean isClosedFieldsCheck, String[] structure, String[] closedStructure, ValidatorsContainer container) {
        int i;
        HashMap<String, String> res = new HashMap<String, String>();
        for (i = 1; i < structure.length; i += 2) {
            res.put(structure[i], structure[i + 1]);
        }
        if (isClosedFieldsCheck) {
            HashMap<String, Pattern> closedRes = new HashMap<String, Pattern>();
            for (int i2 = 0; i2 < closedStructure.length; i2 += 3) {
                closedRes.put(closedStructure[i2], Pattern.compile(closedStructure[i2 + 2]));
            }
            container.registerStructuredWithRestrictedFieldsValidator(structureType, structure[0], res, closedRes);
        } else {
            for (i = 0; i < closedStructure.length; i += 3) {
                res.put(closedStructure[i], closedStructure[i + 1]);
            }
            container.registerStructuredValidator(structureType, structure[0], res);
        }
    }
}

