/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFCharStringsHandler;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.cff.CFFType1FontProgram;
import org.verapdf.pd.font.cff.Type2CharStringParser;
import org.verapdf.pd.font.type1.Type1CharStringParser;

public class CharStringsWidths {
    private static final float DEFAULT_WIDTH = -1.0f;
    private static final Logger LOGGER = Logger.getLogger(CharStringsWidths.class.getCanonicalName());
    private boolean isSubset;
    private int charStringType;
    private CFFCharStringsHandler charStrings;
    private float[] fontMatrix;
    private boolean isDefaultFontMatrix;
    private CFFIndex globalSubrs;
    private CFFIndex[] localSubrIndexes;
    private int[] bias;
    private int[] defaultWidths;
    private int[] nominalWidths;
    private int[] fdSelect;
    private float[] subsetFontWidths;
    private Map<Integer, Float> generalFontWidths;

    public CharStringsWidths(boolean isSubset, int charStringType, CFFCharStringsHandler charStrings, float[] fontMatrix, CFFIndex[] localSubrIndex, CFFIndex globalSubrs, int[] bias, int[] defaultWidths, int[] nominalWidths, int[] fdSelect) {
        this.isSubset = isSubset;
        this.charStringType = charStringType;
        this.charStrings = charStrings;
        this.fontMatrix = fontMatrix;
        this.isDefaultFontMatrix = Arrays.equals(this.fontMatrix, CFFType1FontProgram.DEFAULT_FONT_MATRIX);
        this.localSubrIndexes = localSubrIndex;
        this.globalSubrs = globalSubrs;
        this.bias = bias;
        this.defaultWidths = defaultWidths;
        this.nominalWidths = nominalWidths;
        this.fdSelect = fdSelect;
        if (isSubset) {
            this.parseSubsetWidths();
        } else {
            this.generalFontWidths = new HashMap<Integer, Float>();
        }
    }

    public CharStringsWidths(boolean isSubset, int charStringType, CFFCharStringsHandler charStrings, float[] fontMatrix, CFFIndex localSubrIndex, CFFIndex globalSubrs, int bias, int defaultWidth, int nominalWidth) {
        this(isSubset, charStringType, charStrings, fontMatrix, CharStringsWidths.makeArray(localSubrIndex), globalSubrs, CharStringsWidths.makeArray(bias), CharStringsWidths.makeArray(defaultWidth), CharStringsWidths.makeArray(nominalWidth), null);
    }

    public float getWidth(int gid) {
        if (this.isSubset && gid >= 0 && gid < this.subsetFontWidths.length) {
            return this.subsetFontWidths[gid];
        }
        if (!this.isSubset) {
            Float res = this.generalFontWidths.get(gid);
            if (res != null) {
                return res.floatValue();
            }
            CFFNumber width = this.getWidthFromCharstring(gid);
            res = Float.valueOf(this.getActualWidth(width, gid));
            this.generalFontWidths.put(gid, res);
            return res.floatValue();
        }
        LOGGER.log(Level.FINE, "Can't get width of charstring " + gid + " in font subset, got only " + (this.subsetFontWidths.length - 1) + " charstrings.");
        return -1.0f;
    }

    public int getWidthsAmount() {
        return this.charStrings.getCharStringAmount();
    }

    private CFFNumber getWidthFromCharstring(int gid) {
        try {
            byte[] charstring = this.charStrings.getCharString(gid);
            ASMemoryInStream stream = new ASMemoryInStream(charstring, charstring.length, false);
            if (this.charStringType == 1) {
                Type1CharStringParser parser = new Type1CharStringParser(stream);
                return parser.getWidth();
            }
            if (this.charStringType == 2) {
                Type2CharStringParser parser = new Type2CharStringParser(stream, this.getLocalSubrs(gid), this.getLocalBias(gid), this.globalSubrs, this.getGlobalBias());
                return parser.getWidth();
            }
            throw new IOException("Can't process CharString of type " + this.charStringType);
        }
        catch (IOException e) {
            return new CFFNumber(-1.0f);
        }
    }

    private float getActualWidth(CFFNumber charStringWidth, int gid) {
        float res;
        if (charStringWidth == null) {
            res = this.getDefaultWidth(gid);
        } else {
            res = charStringWidth.isInteger() ? (float)charStringWidth.getInteger() : charStringWidth.getReal();
            res += (float)this.getNominalWidth(gid);
        }
        if (!this.isDefaultFontMatrix) {
            res *= this.fontMatrix[0] * 1000.0f;
        }
        return res;
    }

    private int getDefaultWidth(int gid) {
        return this.getPredefinedValue(gid, this.defaultWidths);
    }

    private int getNominalWidth(int gid) {
        return this.getPredefinedValue(gid, this.nominalWidths);
    }

    private int getPredefinedValue(int gid, int[] widthArray) {
        if (this.fdSelect == null) {
            return widthArray[0];
        }
        return widthArray[this.fdSelect[gid]];
    }

    private int getLocalBias(int gid) {
        return this.getPredefinedValue(gid, this.bias);
    }

    private CFFIndex getLocalSubrs(int gid) {
        if (this.fdSelect == null) {
            return this.localSubrIndexes[0];
        }
        return this.localSubrIndexes[this.fdSelect[gid]];
    }

    private int getGlobalBias() {
        int nSubrs = this.globalSubrs.size();
        if (nSubrs < 1240) {
            return 107;
        }
        if (nSubrs < 33900) {
            return 1131;
        }
        return 32768;
    }

    private void parseSubsetWidths() {
        this.subsetFontWidths = new float[this.charStrings.getCharStringAmount()];
        for (int i = 0; i < this.subsetFontWidths.length; ++i) {
            CFFNumber width = this.getWidthFromCharstring(i);
            this.subsetFontWidths[i] = this.getActualWidth(width, i);
        }
    }

    private static int[] makeArray(int num) {
        int[] res = new int[]{num};
        return res;
    }

    private static CFFIndex[] makeArray(CFFIndex index) {
        CFFIndex[] res = new CFFIndex[]{index};
        return res;
    }
}

