/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.util.Collection;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSIndirect
extends COSBase {
    private COSKey key;
    private COSDocument document;
    private COSObject child;

    protected COSIndirect() throws Exception {
        this.key = new COSKey();
        this.document = new COSDocument(null);
        this.child = new COSObject();
    }

    protected COSIndirect(COSKey key, COSDocument document) {
        this.key = key;
        this.document = document;
        this.child = new COSObject();
    }

    protected COSIndirect(COSObject value, COSDocument document) {
        this.key = new COSKey();
        this.document = document;
        this.child = new COSObject();
        if (document == null) {
            this.child = value;
        } else {
            this.key = this.document.setObject(value);
            this.child = value;
        }
    }

    public COSBase get() {
        return this.child.get();
    }

    @Override
    public COSKey getObjectKey() {
        return this.key;
    }

    @Override
    public COSObjType getType() {
        COSObject direct = this.getDirect();
        return direct == null ? COSObjType.COS_UNDEFINED : direct.getType();
    }

    public static COSObject construct(COSKey value) {
        return COSIndirect.construct(value, null);
    }

    public static COSObject construct(COSKey value, COSDocument doc) {
        return new COSObject(new COSIndirect(value, doc));
    }

    public static COSObject construct(COSObject value) {
        return COSIndirect.construct(value, null);
    }

    public static COSObject construct(COSObject value, COSDocument doc) {
        return new COSObject(new COSIndirect(value, doc));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromIndirect(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return this.get() != null ? this.get().accept(visitor) : COSNull.NULL.accept(visitor);
    }

    @Override
    public Boolean getBoolean() {
        return this.getDirect().getBoolean();
    }

    @Override
    public boolean setBoolean(boolean value) {
        this.getDirect().setBoolean(value);
        return true;
    }

    @Override
    public Long getInteger() {
        return this.getDirect().getInteger();
    }

    @Override
    public boolean setInteger(long value) {
        this.getDirect().setInteger(value);
        return true;
    }

    @Override
    public Double getReal() {
        return this.getDirect().getReal();
    }

    @Override
    public boolean setReal(double value) {
        this.getDirect().setReal(value);
        return true;
    }

    @Override
    public String getString() {
        return this.getDirect().getString();
    }

    @Override
    public boolean setString(String value) {
        return this.setString(value, false);
    }

    @Override
    public boolean setString(String value, boolean isHex) {
        this.getDirect().setString(value);
        return true;
    }

    @Override
    public ASAtom getName() {
        return this.getDirect().getName();
    }

    @Override
    public boolean setName(ASAtom value) {
        this.getDirect().setName(value);
        return true;
    }

    @Override
    public Integer size() {
        return this.getDirect().size();
    }

    @Override
    public COSObject at(int i) {
        return this.getDirect().at(i);
    }

    @Override
    public boolean add(COSObject value) {
        this.getDirect().add(value);
        return true;
    }

    @Override
    public boolean set(int i, COSObject value) {
        this.getDirect().set(i, value);
        return true;
    }

    @Override
    public boolean insert(int i, COSObject value) {
        this.getDirect().insert(i, value);
        return true;
    }

    @Override
    public void remove(int i) {
        this.getDirect().remove(i);
    }

    @Override
    public boolean setArray() {
        this.getDirect().setArray();
        return true;
    }

    @Override
    public boolean setArray(int size, COSObject[] value) {
        this.getDirect().setArray(size, value);
        return true;
    }

    @Override
    public boolean setArray(int size, double[] value) {
        this.getDirect().setArray(size, value);
        return true;
    }

    @Override
    public void clearArray() {
        this.getDirect().clear();
    }

    @Override
    public Boolean knownKey(ASAtom key) {
        return this.getDirect().knownKey(key);
    }

    @Override
    public COSObject getKey(ASAtom key) {
        return this.getDirect().getKey(key);
    }

    @Override
    public boolean setKey(ASAtom key, COSObject value) {
        this.getDirect().setKey(key, value);
        return true;
    }

    @Override
    public Boolean getBooleanKey(ASAtom key) {
        return this.getDirect().getBooleanKey(key);
    }

    @Override
    public boolean setBooleanKey(ASAtom key, boolean value) {
        this.getDirect().setBooleanKey(key, value);
        return true;
    }

    @Override
    public Long getIntegerKey(ASAtom key) {
        return this.getDirect().getIntegerKey(key);
    }

    @Override
    public boolean setIntegerKey(ASAtom key, long value) {
        this.getDirect().setIntegerKey(key, value);
        return true;
    }

    @Override
    public Double getRealKey(ASAtom key) {
        return this.getDirect().getRealKey(key);
    }

    @Override
    public boolean setRealKey(ASAtom key, double value) {
        this.getDirect().setRealKey(key, value);
        return true;
    }

    @Override
    public String getStringKey(ASAtom key) {
        return this.getDirect().getStringKey(key);
    }

    @Override
    public boolean setStringKey(ASAtom key, String value) {
        this.getDirect().setStringKey(key, value);
        return true;
    }

    @Override
    public ASAtom getNameKey(ASAtom key) {
        return this.getDirect().getNameKey(key);
    }

    @Override
    public boolean setNameKey(ASAtom key, ASAtom value) {
        this.getDirect().setNameKey(key, value);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key) {
        this.getDirect().setArrayKey(key);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key, COSObject array) {
        this.getDirect().setArrayKey(key, array);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key, int size, COSObject[] value) {
        this.getDirect().setArrayKey(key, size, value);
        return true;
    }

    @Override
    public boolean setArrayKey(ASAtom key, int size, double[] value) {
        this.getDirect().setArrayKey(key, size, value);
        return true;
    }

    @Override
    public void removeKey(ASAtom key) {
        this.getDirect().removeKey(key);
    }

    @Override
    public Set<ASAtom> getKeySet() {
        return this.getDirect().getKeySet();
    }

    @Override
    public Collection<COSObject> getValues() {
        return this.getDirect().getValues();
    }

    @Override
    public ASInputStream getData() {
        return this.getData(COSStream.FilterFlags.RAW_DATA);
    }

    @Override
    public ASInputStream getData(COSStream.FilterFlags flags) {
        return this.getDirect().getData(flags);
    }

    @Override
    public boolean setData(ASInputStream stream) {
        return this.setData(stream, COSStream.FilterFlags.RAW_DATA);
    }

    @Override
    public boolean setData(ASInputStream stream, COSStream.FilterFlags flags) {
        this.getDirect().setData(stream, flags);
        return true;
    }

    @Override
    public Boolean isStreamKeywordCRLFCompliant() {
        return this.getDirect().isStreamKeywordCRLFCompliant();
    }

    @Override
    public boolean setStreamKeywordCRLFCompliant(boolean streamKeywordCRLFCompliant) {
        this.getDirect().setStreamKeywordCRLFCompliant(streamKeywordCRLFCompliant);
        return true;
    }

    @Override
    public Boolean isEndstreamKeywordCRLFCompliant() {
        return this.getDirect().isEndstreamKeywordCRLFCompliant();
    }

    @Override
    public boolean setEndstreamKeywordCRLFCompliant(boolean endstreamKeywordCRLFCompliant) {
        this.getDirect().setEndstreamKeywordCRLFCompliant(endstreamKeywordCRLFCompliant);
        return true;
    }

    @Override
    public Long getRealStreamSize() {
        return this.getDirect().getRealStreamSize();
    }

    @Override
    public boolean setRealStreamSize(long realStreamSize) {
        this.getDirect().setRealStreamSize(realStreamSize);
        return true;
    }

    @Override
    public Boolean isIndirect() {
        return true;
    }

    @Override
    public COSKey getKey() {
        return this.key;
    }

    @Override
    public COSDocument getDocument() {
        return this.document;
    }

    @Override
    public boolean setKey(COSKey key, COSDocument document) {
        this.key = key;
        this.document = document;
        return true;
    }

    @Override
    public COSObject getDirect() {
        return this.document != null ? this.document.getObject(this.key) : this.child;
    }

    @Override
    public COSBase getDirectBase() {
        return this.document != null ? this.document.getObject(this.key).get() : this.child.get();
    }

    @Override
    public boolean setDirect(COSObject value) {
        if (this.document != null) {
            this.document.setObject(this.key, value);
        } else {
            this.child = value;
        }
        return true;
    }

    @Override
    public void mark() {
        if (this.document != null) {
            COSObject object = new COSObject(this);
            this.document.setObject(object);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSIndirect)) {
            return false;
        }
        COSIndirect that = (COSIndirect)o;
        return this.getDirect().equals(that.getDirect());
    }
}

