/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.gf.utils;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPDateTimeFactory;
import com.adobe.xmp.XMPException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.verapdf.tools.TypeConverter;

public class DateConverter {
    public static String toUTCString(Calendar calendar) {
        return calendar == null ? null : DateConverter.toUTCString(calendar.getTime());
    }

    public static String toUTCString(Date time) {
        if (time == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(time);
    }

    public static String toUTCString(String date) {
        return DateConverter.toUTCString(DateConverter.toCalendar(date));
    }

    public static Calendar toCalendar(String date) {
        if (date == null) {
            return null;
        }
        Calendar buffer = TypeConverter.parseDate(date);
        buffer.setTimeZone(TimeZone.getTimeZone("UTC"));
        return buffer;
    }

    public static String toPDFFormat(String date) {
        try {
            XMPDateTime fromISO8601 = XMPDateTimeFactory.createFromISO8601(date);
            Calendar buffer = fromISO8601.getCalendar();
            buffer.setTimeZone(TimeZone.getTimeZone("UTC"));
            return TypeConverter.getPDFDate(buffer);
        }
        catch (XMPException e) {
            throw new IllegalStateException("Problems with parsing utc date", e);
        }
    }

    public static String toPDFFormat(Calendar date) {
        return TypeConverter.getPDFDate(date);
    }
}

