/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDAppearanceEntry;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.pd.actions.PDAnnotationAdditionalActions;
import org.verapdf.tools.TypeConverter;

public class PDAnnotation
extends PDObject {
    public PDAnnotation(COSObject obj) {
        super(obj);
    }

    public ASAtom getSubtype() {
        return this.getObject().getNameKey(ASAtom.SUBTYPE);
    }

    public Long getF() {
        return this.getObject().getIntegerKey(ASAtom.F);
    }

    public String getContents() {
        return this.getStringKey(ASAtom.CONTENTS);
    }

    public String getAnnotationName() {
        return this.getStringKey(ASAtom.NM);
    }

    public String getModDate() {
        return this.getStringKey(ASAtom.M);
    }

    public Double getCA() {
        return this.getObject().getRealKey(ASAtom.CA);
    }

    public ASAtom getFT() {
        return this.getObject().getNameKey(ASAtom.FT);
    }

    public double[] getRect() {
        return TypeConverter.getRealArray(this.getKey(ASAtom.RECT), 4, "Rect");
    }

    public COSObject getCOSC() {
        COSObject res = this.getKey(ASAtom.C);
        if (res != null && res.getType() == COSObjType.COS_ARRAY) {
            return res;
        }
        return null;
    }

    public COSObject getCOSIC() {
        COSObject res = this.getKey(ASAtom.IC);
        if (res != null && res.getType() == COSObjType.COS_ARRAY) {
            return res;
        }
        return null;
    }

    public COSObject getCOSAP() {
        COSObject appearanceDictionary = this.getKey(ASAtom.AP);
        if (appearanceDictionary != null && appearanceDictionary.getType() == COSObjType.COS_DICT) {
            return appearanceDictionary;
        }
        return null;
    }

    public PDAnnotation getPopup() {
        COSObject popup = this.getKey(ASAtom.POPUP);
        if (popup != null && popup.getType().isDictionaryBased()) {
            return new PDAnnotation(popup);
        }
        return null;
    }

    public double[] getColor() {
        return TypeConverter.getRealArray(this.getKey(ASAtom.C), "Color");
    }

    public boolean isInvisible() {
        return this.getFlagValue(0);
    }

    public boolean isHidden() {
        return this.getFlagValue(1);
    }

    public boolean isPrinted() {
        return this.getFlagValue(2);
    }

    public boolean isNoZoom() {
        return this.getFlagValue(3);
    }

    public boolean isNoRotate() {
        return this.getFlagValue(4);
    }

    public boolean isNoView() {
        return this.getFlagValue(5);
    }

    public boolean isReadOnly() {
        return this.getFlagValue(6);
    }

    public boolean isLocked() {
        return this.getFlagValue(7);
    }

    public boolean isToggleNoView() {
        return this.getFlagValue(8);
    }

    public boolean isLockedContents() {
        return this.getFlagValue(9);
    }

    private boolean getFlagValue(int index) {
        Long flag = this.getIntegerKey(ASAtom.F);
        if (flag != null) {
            int bitFlag;
            long f = flag;
            return (f & (long)(bitFlag = 1 << index)) == (long)bitFlag;
        }
        return false;
    }

    public PDAppearanceEntry getNormalAppearance() {
        return this.getAppearanceEntry(ASAtom.N);
    }

    public PDAppearanceEntry getRolloverAppearance() {
        return this.getAppearanceEntry(ASAtom.R);
    }

    public PDAppearanceEntry getDownAppearance() {
        return this.getAppearanceEntry(ASAtom.D);
    }

    private PDAppearanceEntry getAppearanceEntry(ASAtom key) {
        COSObject appearance;
        COSObject appearanceDictionary = this.getCOSAP();
        if (appearanceDictionary != null && (appearance = appearanceDictionary.getKey(key)) != null && appearance.getType().isDictionaryBased()) {
            return new PDAppearanceEntry(appearance);
        }
        return null;
    }

    public PDAction getA() {
        COSObject action = this.getKey(ASAtom.A);
        if (action != null && action.getType() == COSObjType.COS_DICT) {
            return new PDAction(action);
        }
        return null;
    }

    public PDAnnotationAdditionalActions getAdditionalActions() {
        COSObject aa = this.getKey(ASAtom.AA);
        if (aa != null && aa.getType() == COSObjType.COS_DICT) {
            return new PDAnnotationAdditionalActions(aa);
        }
        return null;
    }
}

