/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDObject;

public class PDMetadata
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(PDMetadata.class.getCanonicalName());

    public PDMetadata(COSObject obj) {
        super(obj);
    }

    public List<ASAtom> getFilters() {
        COSObject filters = this.getKey(ASAtom.FILTER);
        if (filters != null) {
            ArrayList<ASAtom> res = new ArrayList<ASAtom>();
            switch (filters.getType()) {
                case COS_NAME: {
                    res.add(filters.getName());
                    break;
                }
                case COS_ARRAY: {
                    for (int i = 0; i < filters.size(); ++i) {
                        COSObject elem = filters.at(i);
                        if (elem.getType() == COSObjType.COS_NAME) {
                            res.add(elem.getName());
                            continue;
                        }
                        LOGGER.log(Level.FINE, "Filter array contain non COSName element");
                    }
                    break;
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public COSStream getCOSStream() {
        COSBase currentObject = this.getObject().getDirectBase();
        if (currentObject.getType() == COSObjType.COS_STREAM) {
            return (COSStream)currentObject;
        }
        LOGGER.log(Level.FINE, "Current object is not a stream");
        return null;
    }

    public InputStream getStream() {
        COSStream stream = this.getCOSStream();
        if (stream != null) {
            return stream.getData(COSStream.FilterFlags.DECODE);
        }
        return null;
    }
}

