/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cff.CFFCharStringsHandler;
import org.verapdf.pd.font.cff.CFFFontBaseParser;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.cff.CharStringsWidths;
import org.verapdf.pd.font.cmap.CMap;

public class CFFCIDFontProgram
extends CFFFontBaseParser
implements FontProgram {
    private long fdArrayOffset;
    private long fdSelectOffset;
    private Map<Integer, Integer> charSet;
    private boolean isDefaultCharSet = false;
    private int[] fdSelect;
    private int[] nominalWidths;
    private int[] defaultWidths;
    private int supplement;
    private String registry;
    private String ordering;
    private int[] bias;
    private CFFIndex[] localSubrIndexes;
    private CMap externalCMap;

    CFFCIDFontProgram(SeekableInputStream stream, CFFIndex definedNames, CFFIndex globalSubrs, long topDictBeginOffset, long topDictEndOffset, CMap externalCMap, boolean isSubset) {
        super(stream);
        this.definedNames = definedNames;
        this.globalSubrs = globalSubrs;
        this.topDictBeginOffset = topDictBeginOffset;
        this.topDictEndOffset = topDictEndOffset;
        this.externalCMap = externalCMap;
        this.isSubset = isSubset;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            this.attemptedParsing = true;
            this.source.seek(this.topDictBeginOffset);
            while (this.source.getOffset() < this.topDictEndOffset) {
                this.readTopDictUnit();
            }
            this.stack.clear();
            this.source.seek(this.charStringsOffset);
            this.readCharStrings();
            this.source.seek(this.charSetOffset);
            this.readCharSet();
            this.source.seek(this.fdSelectOffset);
            this.readFDSelect();
            this.source.seek(this.fdArrayOffset);
            this.readFontDicts();
            this.readWidths();
            this.successfullyParsed = true;
        }
    }

    @Override
    protected void readTopDictTwoByteOps(int lastRead) throws IOException {
        switch (lastRead) {
            case 30: {
                this.supplement = (int)((CFFNumber)this.stack.get(this.stack.size() - 1)).getInteger();
                this.ordering = this.getStringBySID((int)((CFFNumber)this.stack.get(this.stack.size() - 2)).getInteger());
                this.registry = this.getStringBySID((int)((CFFNumber)this.stack.get(this.stack.size() - 3)).getInteger());
                this.stack.clear();
                break;
            }
            case 36: {
                this.fdArrayOffset = ((CFFNumber)this.stack.get(this.stack.size() - 1)).getInteger();
                this.stack.clear();
                break;
            }
            case 37: {
                this.fdSelectOffset = ((CFFNumber)this.stack.get(this.stack.size() - 1)).getInteger();
                this.stack.clear();
                break;
            }
            default: {
                this.stack.clear();
            }
        }
    }

    private void readCharSet() throws IOException {
        this.charSet = new HashMap<Integer, Integer>(this.nGlyphs);
        this.charSet.put(0, 0);
        int format = this.readCard8();
        switch (format) {
            case 0: {
                for (int i = 1; i < this.nGlyphs; ++i) {
                    this.charSet.put(this.readCard16(), i);
                }
                break;
            }
            case 1: 
            case 2: {
                int charSetPointer = 1;
                while (charSetPointer < this.nGlyphs) {
                    int first = this.readCard16();
                    int nLeft = format == 1 ? this.readCard8() & 0xFF : this.readCard16();
                    for (int i = 0; i <= nLeft; ++i) {
                        this.charSet.put(first + i, charSetPointer++);
                    }
                }
                break;
            }
            default: {
                this.isDefaultCharSet = true;
            }
        }
    }

    private void readFDSelect() throws IOException {
        block7: {
            try {
                int format = this.readCard8();
                this.fdSelect = new int[this.nGlyphs];
                if (format == 0) {
                    for (int i = 0; i < this.nGlyphs; ++i) {
                        this.fdSelect[i] = this.readCard8();
                    }
                    break block7;
                }
                if (format == 3) {
                    int numberOfRanges = this.readCard16();
                    int first = this.readCard16();
                    for (int i = 0; i < numberOfRanges; ++i) {
                        int fd = this.readCard8();
                        int afterLast = this.readCard16();
                        for (int j = first; j < afterLast; ++j) {
                            this.fdSelect[j] = fd;
                        }
                        first = afterLast;
                    }
                    break block7;
                }
                throw new IOException("Can't parse format of FDSelect in CFF file");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Can't parse FDSelect in CFF file", e);
            }
        }
    }

    private void readFontDicts() throws IOException {
        CFFIndex fontDictIndex = this.readIndex();
        this.nominalWidths = new int[fontDictIndex.size()];
        this.defaultWidths = new int[fontDictIndex.size()];
        this.bias = new int[fontDictIndex.size()];
        this.localSubrIndexes = new CFFIndex[fontDictIndex.size()];
        for (int i = 0; i < fontDictIndex.size(); ++i) {
            this.readTopDict((long)fontDictIndex.getOffset(i) + this.fdArrayOffset + (long)fontDictIndex.getOffsetShift() - 1L, (long)fontDictIndex.getOffset(i + 1) + this.fdArrayOffset + (long)fontDictIndex.getOffsetShift() - 1L);
            this.readPrivateDict(this.privateDictOffset, this.privateDictSize, i);
            this.nominalWidths[i] = this.nominalWidthX;
            this.defaultWidths[i] = this.defaultWidthX;
        }
    }

    private void readPrivateDict(long from, long size, int fontDictNum) throws IOException {
        this.stack.clear();
        long startingOffset = this.source.getOffset();
        this.source.seek(from);
        while (this.source.getOffset() < from + size) {
            this.readPrivateDictUnit();
        }
        this.source.seek(startingOffset);
        this.readLocalSubrsAndBias(fontDictNum);
    }

    private void readTopDict(long from, long to) throws IOException {
        this.stack.clear();
        long startingOffset = this.source.getOffset();
        this.source.seek(from);
        while (this.source.getOffset() < to) {
            this.readTopDictUnit();
        }
        this.source.seek(startingOffset);
    }

    private void readWidths() throws IOException {
        CFFCharStringsHandler charStrings = new CFFCharStringsHandler(this.charStrings, this.charStringsOffset, this.source);
        this.widths = new CharStringsWidths(this.isSubset, this.charStringType, charStrings, this.fontMatrix, this.localSubrIndexes, this.globalSubrs, this.bias, this.defaultWidths, this.nominalWidths, this.fdSelect);
    }

    public Integer getGid(int cid) {
        if (this.isDefaultCharSet) {
            return cid;
        }
        return this.charSet.get(cid);
    }

    @Override
    public float getWidth(int code) {
        int cid = this.externalCMap.toCID(code);
        Integer gid = this.getGid(cid);
        return gid == null || gid == 0 ? -1.0f : this.widths.getWidth(gid);
    }

    @Override
    public float getWidth(String glyphName) {
        return 0.0f;
    }

    @Override
    public boolean containsCode(int code) {
        int cid = this.externalCMap.toCID(code);
        return this.externalCMap.containsCode(code) && this.charSet.get(cid) != null && this.charSet.get(cid) != 0;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    private void readLocalSubrsAndBias(int fontDictNum) throws IOException {
        if (this.subrsOffset != -1L) {
            long startOffset = this.source.getOffset();
            this.source.seek(this.subrsOffset);
            this.localSubrIndexes[fontDictNum] = this.readIndex();
            this.source.seek(startOffset);
            int nSubrs = this.localSubrIndexes[fontDictNum].size();
            this.bias[fontDictNum] = this.charStringType == 1 ? 0 : (nSubrs < 1240 ? 107 : (nSubrs < 33900 ? 1131 : 32768));
        }
    }
}

