/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToUnicodeInterval {
    private static final Logger LOGGER = Logger.getLogger(ToUnicodeInterval.class.getCanonicalName());
    private long intervalBegin;
    private long intervalEnd;
    private long startingValue;

    public ToUnicodeInterval(long intervalBegin, long intervalEnd, long startingValue) {
        this.intervalBegin = intervalBegin;
        this.intervalEnd = intervalEnd;
        this.startingValue = startingValue;
    }

    public boolean containsCode(long code) {
        return code >= this.intervalBegin && code <= this.intervalEnd;
    }

    public String toUnicode(int code) {
        long unicode = (long)code - this.intervalBegin + this.startingValue;
        return ToUnicodeInterval.getUnicodeNameFromLong(unicode);
    }

    private static String getUnicodeNameFromLong(long unicode) {
        byte[] arr = new byte[2];
        arr[1] = (byte)(unicode & 0xFFL);
        arr[0] = (byte)((unicode >>= 8) & 0xFFL);
        try {
            if (arr[0] == 0) {
                return String.valueOf(arr[1]);
            }
            return new String(arr, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.FINE, "Can't find String encoding UTF-16BE", e);
            return null;
        }
    }
}

