/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.verapdf.apps.Applications;
import org.verapdf.core.utils.FileUtils;

public final class ApplicationUtils {
    private ApplicationUtils() {
        throw new AssertionError((Object)"Should never happen");
    }

    public static List<File> filterPdfFiles(List<File> toFilter) {
        Applications.checkArgNotNull(toFilter, "toFilter");
        ArrayList<File> retVal = new ArrayList<File>();
        for (File file : toFilter) {
            if (file.isFile() && FileUtils.hasExtNoCase(file.getName(), "pdf")) {
                retVal.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            retVal.addAll(ApplicationUtils.filterPdfFiles(Arrays.asList(file.listFiles())));
        }
        return Collections.unmodifiableList(retVal);
    }

    public static boolean doAllFilesExist(List<File> toCheck) {
        Applications.checkArgNotNull(toCheck, "toCheck");
        if (toCheck.isEmpty()) {
            return false;
        }
        for (File file : toCheck) {
            if (file != null && file.exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalExtension(List<File> toCheck, String[] extensions) {
        Applications.checkArgNotNull(toCheck, "toCheck");
        for (File file : toCheck) {
            if (!file.isFile()) continue;
            boolean isExtMatch = false;
            for (String extension : extensions) {
                if (!FileUtils.hasExtNoCase(file.getName(), extension)) continue;
                isExtMatch = true;
            }
            if (isExtMatch) continue;
            return false;
        }
        return true;
    }
}

