/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.objects.AnnotationFeaturesObject;
import org.verapdf.features.objects.ColorSpaceFeaturesObject;
import org.verapdf.features.objects.DocSecurityFeaturesObject;
import org.verapdf.features.objects.EmbeddedFileFeaturesObject;
import org.verapdf.features.objects.ExtGStateFeaturesObject;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FontFeaturesObject;
import org.verapdf.features.objects.FormXObjectFeaturesObject;
import org.verapdf.features.objects.ICCProfileFeaturesObject;
import org.verapdf.features.objects.ImageXObjectFeaturesObject;
import org.verapdf.features.objects.InfoDictFeaturesObject;
import org.verapdf.features.objects.LowLvlInfoFeaturesObject;
import org.verapdf.features.objects.MetadataFeaturesObject;
import org.verapdf.features.objects.OutlinesFeaturesObject;
import org.verapdf.features.objects.OutputIntentFeaturesObject;
import org.verapdf.features.objects.PageFeaturesObject;
import org.verapdf.features.objects.PostScriptFeaturesObject;
import org.verapdf.features.objects.PropertiesDictFeaturesObject;
import org.verapdf.features.objects.ShadingFeaturesObject;
import org.verapdf.features.objects.SignatureFeaturesObject;

public final class FeaturesStructureContainer {
    private static Map<FeatureObjectType, List<Feature>> featuresStructure = new EnumMap<FeatureObjectType, List<Feature>>(FeatureObjectType.class);

    private FeaturesStructureContainer() {
    }

    public static List<Feature> getFeaturesListForType(FeatureObjectType type) {
        List<Feature> res = featuresStructure.get((Object)type);
        return res == null ? Collections.emptyList() : Collections.unmodifiableList(res);
    }

    static {
        featuresStructure.put(FeatureObjectType.ANNOTATION, AnnotationFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.COLORSPACE, ColorSpaceFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.DOCUMENT_SECURITY, DocSecurityFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.EMBEDDED_FILE, EmbeddedFileFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.EXT_G_STATE, ExtGStateFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.FONT, FontFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.FORM_XOBJECT, FormXObjectFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.ICCPROFILE, ICCProfileFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.IMAGE_XOBJECT, ImageXObjectFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.INFORMATION_DICTIONARY, InfoDictFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.LOW_LEVEL_INFO, LowLvlInfoFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.METADATA, MetadataFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.OUTLINES, OutlinesFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.OUTPUTINTENT, OutputIntentFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.PAGE, PageFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.POSTSCRIPT_XOBJECT, PostScriptFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.PROPERTIES, PropertiesDictFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.SHADING, ShadingFeaturesObject.getFeaturesList());
        featuresStructure.put(FeatureObjectType.SIGNATURE, SignatureFeaturesObject.getFeaturesList());
    }
}

