/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSNumber;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.impl.pb.cos.PBCosInteger;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.cos.PBCosReal;

public abstract class PBCosNumber
extends PBCosObject
implements CosNumber {
    private final long longVal;
    private final double doubleVal;

    protected PBCosNumber(COSNumber number, String type) {
        super(number, type);
        this.longVal = number.longValue();
        this.doubleVal = number.doubleValue();
    }

    public static PBCosNumber fromPDFBoxNumber(COSBase number) {
        if (number instanceof COSInteger) {
            return new PBCosInteger((COSInteger)number);
        }
        if (number instanceof COSFloat) {
            return new PBCosReal((COSFloat)number);
        }
        return null;
    }

    @Override
    public String getstringValue() {
        return String.valueOf(this.doubleVal);
    }

    @Override
    public Long getintValue() {
        return this.longVal;
    }

    @Override
    public Double getrealValue() {
        return this.doubleVal;
    }
}

