/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.gf.impl.schemas;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.gf.impl.schemas.BasicSchemaImpl;
import org.verapdf.metadata.fixer.schemas.DublinCore;

public class DublinCoreSchemaImpl
extends BasicSchemaImpl
implements DublinCore {
    private static final Logger LOGGER = Logger.getLogger(DublinCoreSchemaImpl.class.getCanonicalName());

    public DublinCoreSchemaImpl(VeraPDFMeta meta, Metadata metadata) {
        super(meta, metadata);
    }

    public String getTitle() {
        try {
            return this.meta.getTitle();
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not get title.", e);
            throw new IllegalStateException(e);
        }
    }

    public void setTitle(String title) {
        try {
            this.meta.setTitle(title);
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not set title.", e);
            throw new IllegalStateException(e);
        }
    }

    public String getSubject() {
        try {
            return this.meta.getDescription();
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not get subject.", e);
            throw new IllegalStateException(e);
        }
    }

    public void setSubject(String description) {
        try {
            this.meta.setDescription(description);
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not set description.", e);
            throw new IllegalStateException(e);
        }
    }

    public String getAuthor() {
        try {
            List creators = this.meta.getCreator();
            if (creators == null) {
                return null;
            }
            if (creators.size() > 1) {
                StringBuilder builder = new StringBuilder();
                for (String str : creators) {
                    builder.append(str).append(", ");
                }
                ArrayList<String> res = new ArrayList<String>(1);
                String s = builder.toString();
                res.add(s.substring(0, s.length() - 2));
                this.meta.setCreator(res);
                return (String)res.get(0);
            }
            return creators.size() == 0 ? null : (String)creators.get(0);
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not get creator.", e);
            throw new IllegalStateException(e);
        }
    }

    public void setAuthor(String creator) {
        try {
            ArrayList<String> res = new ArrayList<String>(1);
            res.add(creator);
            this.meta.setCreator(res);
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not set creator.", e);
            throw new IllegalStateException(e);
        }
    }
}

