/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.serializer;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.verapdf.model.Entity;
import org.verapdf.model.Import;
import org.verapdf.model.Link;
import org.verapdf.model.Model;
import org.verapdf.model.ModelPackage;
import org.verapdf.model.Property;
import org.verapdf.services.ModelGrammarAccess;

public class ModelSemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private ModelGrammarAccess grammarAccess;

    public void createSequence(EObject context, EObject semanticObject) {
        if (semanticObject.eClass().getEPackage() == ModelPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 1: {
                    this.sequence_Entity(context, (Entity)semanticObject);
                    return;
                }
                case 5: {
                    this.sequence_Import(context, (Import)semanticObject);
                    return;
                }
                case 4: {
                    this.sequence_Link(context, (Link)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_Model(context, (Model)semanticObject);
                    return;
                }
                case 3: {
                    this.sequence_Property(context, (Property)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Entity(EObject context, Entity semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Import(EObject context, Import semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)ModelPackage.Literals.IMPORT__IMPORTED_NAMESPACE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)ModelPackage.Literals.IMPORT__IMPORTED_NAMESPACE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_0(), (Object)semanticObject.getImportedNamespace());
        feeder.finish();
    }

    protected void sequence_Link(EObject context, Link semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Model(EObject context, Model semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Property(EObject context, Property semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }
}

