/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.CharTable;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSHeader;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSTrailer;
import org.verapdf.cos.xref.COSXRefEntry;
import org.verapdf.cos.xref.COSXRefInfo;
import org.verapdf.cos.xref.COSXRefSection;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.COSParser;
import org.verapdf.parser.Token;
import org.verapdf.parser.XrefStreamParser;

public class PDFParser
extends COSParser {
    private static final Logger LOGGER = Logger.getLogger(PDFParser.class.getCanonicalName());
    private static final String HEADER_PATTERN = "%PDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final byte[] STARTXREF = "startxref".getBytes();
    private static final byte[] EOF_MARKER = new byte[]{37, 37, 69, 79, 70};
    private long offsetShift = 0L;
    private boolean isEncrypted;
    private COSObject encryption;
    private Long lastTrailerOffset = 0L;

    public PDFParser(String filename) throws IOException {
        super(filename);
    }

    public PDFParser(InputStream fileStream) throws IOException {
        super(fileStream);
    }

    public PDFParser(COSDocument document, String filename) throws IOException {
        super(document, filename);
    }

    public PDFParser(COSDocument document, InputStream fileStream) throws IOException {
        super(document, fileStream);
    }

    public COSHeader getHeader() throws IOException {
        return this.parseHeader();
    }

    public SeekableInputStream getPDFSource() {
        return this.source;
    }

    private COSHeader parseHeader() throws IOException {
        long headerOffset;
        COSHeader result = new COSHeader();
        String header = this.getLine(0);
        if (!header.contains(HEADER_PATTERN)) {
            header = this.getLine();
            while (!(header.contains(HEADER_PATTERN) || header.contains(HEADER_PATTERN.substring(1)) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.getLine();
            }
        }
        do {
            this.source.unread();
        } while (this.isNextByteEOL());
        this.source.readByte();
        int headerStart = header.indexOf(HEADER_PATTERN);
        this.offsetShift = headerOffset = this.source.getOffset() - (long)header.length() + (long)headerStart;
        result.setHeaderOffset(headerOffset);
        result.setHeader(header);
        this.skipSingleEol();
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(HEADER_PATTERN) && !header.matches("%PDF-\\d.\\d")) {
            if (header.length() < HEADER_PATTERN.length() + 3) {
                header = "%PDF-1.4";
                LOGGER.log(Level.WARNING, "No version found, set to 1.4 as default.");
            } else {
                Integer pos = null;
                if (header.indexOf(37) > -1) {
                    pos = header.indexOf(37);
                } else if (header.contains("PDF-")) {
                    pos = header.indexOf("PDF-");
                }
                if (pos != null) {
                    int length = Math.min(8, header.substring(pos).length());
                    header = header.substring(pos, pos + length);
                }
            }
        }
        float headerVersion = 1.4f;
        try {
            String[] headerParts = header.split("-");
            if (headerParts.length == 2) {
                headerVersion = Float.parseFloat(headerParts[1]);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Can't parse the header version.", e);
        }
        result.setVersion(headerVersion);
        this.checkComment(result);
        this.source.seek(0L);
        return result;
    }

    public boolean isLinearized() {
        try {
            long length;
            COSObject linDict = this.findFirstDictionary();
            if (linDict != null && !linDict.empty() && linDict.getType() == COSObjType.COS_DICT && linDict.knownKey(ASAtom.LINEARIZED).booleanValue() && (length = linDict.getIntegerKey(ASAtom.L).longValue()) != 0L) {
                return length == this.source.getStreamLength() && this.source.getOffset() < 1024L;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "IO error while trying to find first document dictionary", e);
        }
        return false;
    }

    private COSObject findFirstDictionary() throws IOException {
        this.source.seek(0L);
        if (this.findKeyword(Token.Keyword.KW_OBJ, 1024)) {
            this.source.unread(7);
            this.source.unread();
            while (!CharTable.isSpace(this.source.read())) {
                this.source.unread(2);
            }
            return this.getObject(this.source.getOffset());
        }
        return null;
    }

    private void checkComment(COSHeader header) throws IOException {
        byte[] comment = this.getLineBytes();
        boolean isValidComment = true;
        if (comment != null && comment.length != 0) {
            if (comment[0] != 37) {
                isValidComment = false;
            }
            if (comment.length < 5) {
                isValidComment = false;
            }
        } else {
            isValidComment = false;
        }
        if (isValidComment) {
            header.setBinaryHeaderBytes(comment[1], comment[2], comment[3], comment[4]);
        } else {
            header.setBinaryHeaderBytes(0, 0, 0, 0);
        }
    }

    public void getXRefInfo(List<COSXRefInfo> infos) throws IOException {
        this.calculatePostEOFDataSize();
        this.getXRefInfo(infos, new HashSet<Long>(), 0L);
    }

    public COSObject getObject(long offset) throws IOException {
        COSObject obj;
        this.clear();
        this.source.seek(offset);
        Token token = this.getToken();
        boolean headerOfObjectComplyPDFA = true;
        boolean headerFormatComplyPDFA = true;
        boolean endOfObjectComplyPDFA = true;
        this.skipSpaces(false);
        this.source.seek(this.source.getOffset() - 1L);
        if (!this.isNextByteEOL()) {
            headerOfObjectComplyPDFA = false;
        }
        this.source.skip(1);
        this.nextToken();
        if (token.type != Token.Type.TT_INTEGER) {
            return new COSObject();
        }
        long number = token.integer;
        if (!CharTable.isSpace(this.source.read()) || CharTable.isSpace(this.source.peek())) {
            headerFormatComplyPDFA = false;
        }
        this.nextToken();
        if (token.type != Token.Type.TT_INTEGER) {
            return new COSObject();
        }
        long generation = token.integer;
        if (!CharTable.isSpace(this.source.read()) || CharTable.isSpace(this.source.peek())) {
            headerFormatComplyPDFA = false;
        }
        this.nextToken();
        if (token.type != Token.Type.TT_KEYWORD && token.keyword != Token.Keyword.KW_OBJ) {
            return new COSObject();
        }
        this.keyOfCurrentObject = new COSKey((int)number, (int)generation);
        if (this.document.isReaderInitialized() && this.document.getOffset(this.keyOfCurrentObject) == 0L) {
            return new COSObject();
        }
        if (!this.isNextByteEOL()) {
            headerOfObjectComplyPDFA = false;
        }
        if ((obj = this.nextObject()).getType() == COSObjType.COS_STREAM) {
            try {
                if (this.document.isEncrypted()) {
                    this.document.getStandardSecurityHandler().decryptStream((COSStream)obj.getDirectBase(), new COSKey((int)number, (int)generation));
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Stream " + this.keyOfCurrentObject + " cannot be decrypted", e);
            }
        }
        long beforeSkip = this.source.getOffset();
        this.skipSpaces();
        if (this.source.getOffset() != beforeSkip) {
            this.source.unread();
        }
        if (!this.isNextByteEOL()) {
            endOfObjectComplyPDFA = false;
        }
        long offsetBeforeEndobj = this.source.getOffset();
        if (this.flag) {
            this.nextToken();
        }
        this.flag = true;
        if (token.type != Token.Type.TT_KEYWORD && token.keyword != Token.Keyword.KW_ENDOBJ) {
            LOGGER.log(Level.WARNING, "No endobj keyword at offset " + offsetBeforeEndobj);
            this.source.seek(offsetBeforeEndobj);
        }
        if (!this.isNextByteEOL()) {
            endOfObjectComplyPDFA = false;
        }
        obj.setIsHeaderOfObjectComplyPDFA(headerOfObjectComplyPDFA);
        obj.setIsHeaderFormatComplyPDFA(headerFormatComplyPDFA);
        obj.setIsEndOfObjectComplyPDFA(endOfObjectComplyPDFA);
        return obj;
    }

    private void clear() {
        this.objects.clear();
        this.integers.clear();
        this.flag = true;
    }

    private Long findLastXRef() throws IOException {
        this.source.seekFromEnd(STARTXREF.length);
        byte[] buf = new byte[STARTXREF.length];
        while (this.source.getStreamLength() - this.source.getOffset() < 1024L) {
            long res = this.source.getOffset();
            this.source.read(buf);
            if (Arrays.equals(buf, STARTXREF)) {
                this.nextToken();
                return this.getToken().integer;
            }
            this.source.seekFromCurrentPosition(-STARTXREF.length - 1);
        }
        return 0L;
    }

    private void calculatePostEOFDataSize() throws IOException {
        int lookupSize = 1024;
        this.source.seekFromEnd(1024L);
        byte[] buffer = new byte[1024];
        this.source.read(buffer, 1024);
        byte postEOFDataSize = -1;
        byte patternSize = (byte)EOF_MARKER.length;
        byte currentMarkerOffset = (byte)(patternSize - 1);
        byte lookupByte = EOF_MARKER[currentMarkerOffset];
        for (int currentBufferOffset = 1023; currentBufferOffset >= 0; --currentBufferOffset) {
            if (buffer[currentBufferOffset] == lookupByte) {
                if (currentMarkerOffset == 0) {
                    postEOFDataSize = (byte)(1024 - currentBufferOffset);
                    if ((postEOFDataSize = (byte)(postEOFDataSize - EOF_MARKER.length)) > 0) {
                        if (buffer[currentBufferOffset + EOF_MARKER.length] == 13) {
                            if (++currentBufferOffset + EOF_MARKER.length < buffer.length && buffer[currentBufferOffset + EOF_MARKER.length] == 10) {
                                postEOFDataSize = (byte)(postEOFDataSize - 2);
                                this.document.setPostEOFDataSize(postEOFDataSize);
                                return;
                            }
                            postEOFDataSize = (byte)(postEOFDataSize - 1);
                            this.document.setPostEOFDataSize(postEOFDataSize);
                            return;
                        }
                        if (buffer[currentBufferOffset + EOF_MARKER.length] == 10) {
                            postEOFDataSize = (byte)(postEOFDataSize - 1);
                            this.document.setPostEOFDataSize(postEOFDataSize);
                            return;
                        }
                        this.document.setPostEOFDataSize(postEOFDataSize);
                        return;
                    }
                    this.document.setPostEOFDataSize(postEOFDataSize);
                    return;
                }
                currentMarkerOffset = (byte)(currentMarkerOffset - 1);
                lookupByte = EOF_MARKER[currentMarkerOffset];
                continue;
            }
            if (currentMarkerOffset >= patternSize - 1) continue;
            currentMarkerOffset = (byte)(patternSize - 1);
            lookupByte = EOF_MARKER[currentMarkerOffset];
        }
        this.document.setPostEOFDataSize(postEOFDataSize);
    }

    private void getXRefSectionAndTrailer(COSXRefInfo section) throws IOException {
        if (this.lastTrailerOffset == 0L) {
            this.lastTrailerOffset = this.source.getOffset();
        }
        this.nextToken();
        if ((this.getToken().type != Token.Type.TT_KEYWORD || this.getToken().keyword != Token.Keyword.KW_XREF) && this.getToken().type != Token.Type.TT_INTEGER) {
            throw new IOException("PDFParser::GetXRefSection(...)can not locate xref table");
        }
        if (this.getToken().type != Token.Type.TT_INTEGER) {
            this.parseXrefTable(section.getXRefSection());
            this.getTrailer(section.getTrailer());
        } else {
            this.parseXrefStream(section);
        }
    }

    private void parseXrefTable(COSXRefSection xrefs) throws IOException {
        byte space = this.source.readByte();
        if (PDFParser.isCR(space)) {
            if (PDFParser.isLF(this.source.peek())) {
                this.source.readByte();
            }
            if (!this.isDigit()) {
                this.document.setXrefEOLMarkersComplyPDFA(false);
            }
        } else if (!PDFParser.isLF(space) || !this.isDigit()) {
            this.document.setXrefEOLMarkersComplyPDFA(false);
        }
        this.nextToken();
        while (this.getToken().type == Token.Type.TT_INTEGER) {
            space = this.source.readByte();
            if (space != 32 || !this.isDigit()) {
                this.document.setSubsectionHeaderSpaceSeparated(false);
            }
            int number = (int)this.getToken().integer;
            this.nextToken();
            int count = (int)this.getToken().integer;
            for (int i = 0; i < count; ++i) {
                COSXRefEntry xref = new COSXRefEntry();
                this.nextToken();
                xref.offset = this.getToken().integer;
                this.nextToken();
                xref.generation = (int)this.getToken().integer;
                this.nextToken();
                xref.free = this.getToken().getValue().charAt(0);
                xrefs.addEntry(number + i, xref);
            }
            this.nextToken();
        }
        this.source.seekFromCurrentPosition(-7L);
    }

    private void parseXrefStream(COSXRefInfo section) throws IOException {
        this.nextToken();
        if (this.getToken().type != Token.Type.TT_INTEGER) {
            throw new IOException("PDFParser::GetXRefSection(...)can not locate xref table");
        }
        this.nextToken();
        if (this.getToken().type != Token.Type.TT_KEYWORD || this.getToken().keyword != Token.Keyword.KW_OBJ) {
            throw new IOException("PDFParser::GetXRefSection(...)can not locate xref table");
        }
        COSObject xrefCOSStream = this.getDictionary();
        if (xrefCOSStream.getType() != COSObjType.COS_STREAM) {
            throw new IOException("PDFParser::GetXRefSection(...)can not locate xref table");
        }
        XrefStreamParser xrefStreamParser = new XrefStreamParser(section, (COSStream)xrefCOSStream.getDirectBase());
        xrefStreamParser.parseStreamAndTrailer();
        if (section.getTrailer().knownKey(ASAtom.ENCRYPT)) {
            this.isEncrypted = true;
            this.encryption = section.getTrailer().getEncrypt();
        }
    }

    private void getXRefInfo(List<COSXRefInfo> info, Set<Long> processedOffsets, Long offset) throws IOException {
        if (offset == 0L && (offset = this.findLastXRef()) == 0L) {
            throw new IOException("PDFParser::GetXRefInfo(...)startxref validation failed");
        }
        if (processedOffsets.contains(offset)) {
            throw new LoopedException("XRef loop");
        }
        processedOffsets.add(offset);
        this.clear();
        if (this.offsetShift > 0L) {
            offset = offset + this.offsetShift;
        }
        this.source.seek(offset.intValue() - 1);
        COSXRefInfo section = new COSXRefInfo();
        info.add(0, section);
        section.setStartXRef(offset);
        this.getXRefSectionAndTrailer(section);
        offset = section.getTrailer().getPrev();
        if (offset == null || offset == 0L) {
            return;
        }
        this.getXRefInfo(info, processedOffsets, offset);
    }

    private void getTrailer(COSTrailer trailer) throws IOException {
        if (this.findKeyword(Token.Keyword.KW_TRAILER)) {
            COSObject obj = this.nextObject();
            trailer.setObject(obj);
        }
        if (trailer.knownKey(ASAtom.ENCRYPT)) {
            this.isEncrypted = true;
            this.encryption = trailer.getEncrypt();
        }
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public COSObject getEncryption() {
        return this.encryption;
    }

    public Long getLastTrailerOffset() {
        return this.lastTrailerOffset;
    }
}

