/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.stdmetrics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardFontMetrics {
    private static final String NOTDEF_STRING = ".notdef";
    private Map<String, Integer> widths = new HashMap<String, Integer>();
    private String fontName;
    private String familyName;
    private double[] fontBBox;
    private String encodingScheme;
    private String charSet;
    private Double capHeight;
    private Double XHeight;
    private Double ascend;
    private Double descend;
    private Double italicAngle;

    StandardFontMetrics() {
    }

    void putWidth(String glyphName, int width) {
        this.widths.put(glyphName, width);
    }

    public int getWidth(String glyphName) {
        Integer res = this.widths.get(glyphName);
        return res == null ? this.widths.get(NOTDEF_STRING) : res;
    }

    public String getFontName() {
        return this.fontName;
    }

    void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public double[] getFontBBox() {
        return this.fontBBox;
    }

    void setFontBBox(double[] fontBBox) {
        this.fontBBox = fontBBox;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public String getCharSet() {
        return this.charSet;
    }

    void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public Double getCapHeight() {
        return this.capHeight;
    }

    void setCapHeight(Double capHeight) {
        this.capHeight = capHeight;
    }

    public Double getXHeight() {
        return this.XHeight;
    }

    public void setXHeight(Double XHeight) {
        this.XHeight = XHeight;
    }

    public Double getAscend() {
        return this.ascend;
    }

    void setAscend(Double ascend) {
        this.ascend = ascend;
    }

    public Double getDescend() {
        return this.descend;
    }

    void setDescend(Double descend) {
        this.descend = descend;
    }

    public Double getItalicAngle() {
        return this.italicAngle;
    }

    void setItalicAngle(Double italicAngle) {
        this.italicAngle = italicAngle;
    }

    public Iterator<Map.Entry<String, Integer>> getWidthsIterator() {
        return this.widths.entrySet().iterator();
    }
}

