/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.factory.fonts.PDFontFactory;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShading;

public class PDResources
extends PDObject {
    private Map<ASAtom, PDColorSpace> colorSpaceMap = new HashMap<ASAtom, PDColorSpace>();
    private Map<ASAtom, PDPattern> patternMap = new HashMap<ASAtom, PDPattern>();
    private Map<ASAtom, PDShading> shadingMap = new HashMap<ASAtom, PDShading>();
    private Map<ASAtom, PDXObject> xObjectMap = new HashMap<ASAtom, PDXObject>();
    private Map<ASAtom, PDExtGState> extGStateMap = new HashMap<ASAtom, PDExtGState>();
    private Map<ASAtom, PDFont> fontMap = new HashMap<ASAtom, PDFont>();
    private Map<ASAtom, PDResource> propertiesMap = new HashMap<ASAtom, PDResource>();

    public PDResources(COSObject resourcesDictionary) {
        super(resourcesDictionary);
    }

    public PDColorSpace getColorSpace(ASAtom name) {
        return this.getColorSpace(name, false);
    }

    public PDColorSpace getColorSpace(ASAtom name, boolean isDefault) {
        if (this.colorSpaceMap.containsKey(name)) {
            return this.colorSpaceMap.get(name);
        }
        COSObject rawColorSpace = this.getResource(ASAtom.COLORSPACE, name);
        PDColorSpace colorSpace = rawColorSpace != null && !rawColorSpace.empty() ? ColorSpaceFactory.getColorSpace(rawColorSpace, this, isDefault) : ColorSpaceFactory.getColorSpace(COSName.construct(name), this, isDefault);
        this.colorSpaceMap.put(name, colorSpace);
        return colorSpace;
    }

    public PDColorSpace getDefaultColorSpace(ASAtom name) {
        ASAtom defaultName = ColorSpaceFactory.getDefaultValue(this, name);
        if (this.hasColorSpace(defaultName)) {
            return this.getColorSpace(defaultName, true);
        }
        return null;
    }

    public boolean hasColorSpace(ASAtom name) {
        COSObject colorSpace = this.getResource(ASAtom.COLORSPACE, name);
        return colorSpace != null && !colorSpace.empty();
    }

    public PDPattern getPattern(ASAtom name) {
        if (this.patternMap.containsKey(name)) {
            return this.patternMap.get(name);
        }
        COSObject rawPattern = this.getResource(ASAtom.PATTERN, name);
        PDColorSpace cs = ColorSpaceFactory.getColorSpace(rawPattern);
        if (cs != null && ASAtom.PATTERN.equals(cs.getType())) {
            PDPattern pattern = (PDPattern)cs;
            this.patternMap.put(name, pattern);
            return pattern;
        }
        this.patternMap.put(name, null);
        return null;
    }

    public PDShading getShading(ASAtom name) {
        if (this.shadingMap.containsKey(name)) {
            return this.shadingMap.get(name);
        }
        COSObject rawShading = this.getResource(ASAtom.SHADING, name);
        PDShading shading = new PDShading(rawShading);
        this.shadingMap.put(name, shading);
        return shading;
    }

    public PDXObject getXObject(ASAtom name) {
        if (this.xObjectMap.containsKey(name)) {
            return this.xObjectMap.get(name);
        }
        COSObject rawXObject = this.getResource(ASAtom.XOBJECT, name);
        PDXObject pdxObject = PDXObject.getTypedPDXObject(rawXObject, this);
        this.xObjectMap.put(name, pdxObject);
        return pdxObject;
    }

    public PDExtGState getExtGState(ASAtom name) {
        if (this.extGStateMap.containsKey(name)) {
            return this.extGStateMap.get(name);
        }
        COSObject rawExtGState = this.getResource(ASAtom.EXT_G_STATE, name);
        PDExtGState extGState = new PDExtGState(rawExtGState);
        this.extGStateMap.put(name, extGState);
        return extGState;
    }

    public PDFont getFont(ASAtom name) {
        if (this.fontMap.containsKey(name)) {
            return this.fontMap.get(name);
        }
        COSObject rawFont = this.getResource(ASAtom.FONT, name);
        PDFont font = PDFontFactory.getPDFont(rawFont);
        this.fontMap.put(name, font);
        return font;
    }

    public PDResource getProperties(ASAtom name) {
        if (this.propertiesMap.containsKey(name)) {
            return this.propertiesMap.get(name);
        }
        COSObject rawProperties = this.getResource(ASAtom.PROPERTIES, name);
        PDResource properties = new PDResource(rawProperties);
        this.propertiesMap.put(name, properties);
        return properties;
    }

    public Set<ASAtom> getExtGStateNames() {
        return this.getNames(ASAtom.EXT_G_STATE);
    }

    public Set<ASAtom> getColorSpaceNames() {
        return this.getNames(ASAtom.COLORSPACE);
    }

    public Set<ASAtom> getPatternNames() {
        return this.getNames(ASAtom.PATTERN);
    }

    public Set<ASAtom> getShadingNames() {
        return this.getNames(ASAtom.SHADING);
    }

    public Set<ASAtom> getXObjectNames() {
        return this.getNames(ASAtom.XOBJECT);
    }

    public Set<ASAtom> getFontNames() {
        return this.getNames(ASAtom.FONT);
    }

    public Set<ASAtom> getPropertiesNames() {
        return this.getNames(ASAtom.PROPERTIES);
    }

    private Set<ASAtom> getNames(ASAtom type) {
        COSObject dict = this.getKey(type);
        if (dict != null && dict.getType() == COSObjType.COS_DICT) {
            return dict.getKeySet();
        }
        return Collections.emptySet();
    }

    private COSObject getResource(ASAtom type, ASAtom name) {
        COSObject dict = this.getKey(type);
        if (dict != null) {
            return dict.getKey(name);
        }
        return null;
    }
}

