/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.SeekableInputStream;

class TrueTypeBaseParser {
    private static final int TWO_POWER_16 = 65536;
    protected SeekableInputStream source;

    protected TrueTypeBaseParser(ASInputStream stream) throws IOException {
        this.source = SeekableInputStream.getSeekableStream(stream);
    }

    protected TrueTypeBaseParser(SeekableInputStream source) {
        this.source = source;
    }

    protected TrueTypeBaseParser() {
    }

    protected int readByte() throws IOException {
        return this.source.readByte() & 0xFF;
    }

    protected byte readChar() throws IOException {
        return this.source.readByte();
    }

    protected int readUShort() throws IOException {
        int highOrder = (this.source.readByte() & 0xFF) << 8;
        return highOrder | this.source.readByte() & 0xFF;
    }

    protected int readShort() throws IOException {
        return (short)this.readUShort();
    }

    protected long readULong() throws IOException {
        long res = this.readUShort();
        return (res <<= 16) | (long)this.readUShort();
    }

    protected int readLong() throws IOException {
        int res = this.readUShort();
        return (res <<= 16) | this.readUShort();
    }

    protected float readFixed() throws IOException {
        byte[] buf = new byte[4];
        this.source.read(buf, 4);
        int integer = 0;
        for (int i = 0; i < 3; ++i) {
            integer |= buf[i] & 0xFF;
            integer <<= 8;
        }
        float res = integer |= buf[3] & 0xFF;
        return res / 65536.0f;
    }

    protected int readFWord() throws IOException {
        return this.readShort();
    }

    protected int readUFWord() throws IOException {
        return this.readUShort();
    }
}

