/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;

public class TypeConverter {
    private static final Logger LOGGER = Logger.getLogger(TypeConverter.class.getCanonicalName());
    private static final String INVALID_DATE_LOG_BASE = "Parsed string is not complies pdf date format. ";

    public static Calendar parseDate(String toParse) {
        if (toParse != null && toParse.startsWith("D:")) {
            if (toParse.endsWith("'")) {
                if (toParse.endsWith("''")) {
                    return TypeConverter.getErrorDateFormat("Trailing apostrophe duplication");
                }
                toParse = toParse.substring(0, toParse.length() - 1);
            }
            if (!TypeConverter.isDigits(toParse, 2, 4)) {
                return TypeConverter.getErrorDateFormat("Incorrect year data.");
            }
            int year = Integer.parseInt(toParse.substring(2, 6));
            int month = 1;
            int day = 1;
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            String sign = "Z";
            int timeZoneHours = 0;
            int timeZoneMins = 0;
            int length = toParse.length();
            if (length > 6) {
                if (TypeConverter.isDigits(toParse, 6, 2)) {
                    month = Integer.parseInt(toParse.substring(6, 8)) - 1;
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect month data.");
                }
            }
            if (length > 8) {
                if (TypeConverter.isDigits(toParse, 8, 2)) {
                    day = Integer.parseInt(toParse.substring(8, 10));
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect day data.");
                }
            }
            if (length > 10) {
                if (TypeConverter.isDigits(toParse, 10, 2)) {
                    hour = Integer.parseInt(toParse.substring(10, 12));
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect hour data.");
                }
            }
            if (length > 12) {
                if (TypeConverter.isDigits(toParse, 12, 2)) {
                    minutes = Integer.parseInt(toParse.substring(12, 14));
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect minutes data.");
                }
            }
            if (length > 14) {
                if (TypeConverter.isDigits(toParse, 14, 2)) {
                    seconds = Integer.parseInt(toParse.substring(14, 16));
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect seconds data.");
                }
            }
            if (length > 16) {
                sign = toParse.substring(16, 17);
                if (!sign.matches("^[Z+-]$")) {
                    return TypeConverter.getErrorDateFormat("Incorrect time zone beginning.");
                }
                if ("Z".equals(sign) && length > 17) {
                    return TypeConverter.getErrorDateFormat("Incorrect ending with Z time zone.");
                }
            }
            if (length > 17) {
                if (TypeConverter.isDigits(toParse, 17, 2)) {
                    timeZoneHours = Integer.parseInt(toParse.substring(17, 19));
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect time zone hours data.");
                }
            }
            if (length > 19 && !"'".equals(toParse.substring(19, 20))) {
                return TypeConverter.getErrorDateFormat("Missing apostrophe delimiter.");
            }
            if (length > 20) {
                if (TypeConverter.isDigits(toParse, 20, 2)) {
                    timeZoneMins = Integer.parseInt(toParse.substring(20, 22));
                } else {
                    return TypeConverter.getErrorDateFormat("Incorrect time zone minutes data.");
                }
            }
            if (length > 22) {
                return TypeConverter.getErrorDateFormat("Incorrect ending.");
            }
            TimeZone zone = !sign.equals("Z") ? TimeZone.getTimeZone(String.format("GMT%s%d:%02d", sign, timeZoneHours, timeZoneMins)) : TimeZone.getTimeZone("GMT");
            GregorianCalendar res = new GregorianCalendar(zone);
            res.set(year, month, day, hour, minutes, seconds);
            res.set(14, 0);
            return res;
        }
        return TypeConverter.getErrorDateFormat("String is null or has incorrect beginning.");
    }

    private static Calendar getErrorDateFormat(String logMessageEnd) {
        LOGGER.log(Level.FINE, INVALID_DATE_LOG_BASE + logMessageEnd);
        return null;
    }

    public static String getPDFDate(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(11);
        int min = date.get(12);
        int sec = date.get(13);
        SimpleDateFormat sdf = new SimpleDateFormat("Z");
        sdf.setTimeZone(date.getTimeZone());
        String tz = sdf.format(new Date());
        return String.format("D:%04d%02d%02d%02d%02d%02d%s'%s", year, month, day, hour, min, sec, tz.substring(0, 3), tz.substring(3, 5));
    }

    private static boolean isDigits(String toCheck, int offset, int length) {
        int end = offset + length;
        if (end > toCheck.length()) {
            return false;
        }
        for (int i = offset; i < end; ++i) {
            if (Character.isDigit(toCheck.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static double[] getRealArray(COSObject array, int estimatedSize, String arrayName) {
        return TypeConverter.getRealArray(array, estimatedSize, arrayName, true);
    }

    public static double[] getRealArray(COSObject array, String arrayName) {
        return TypeConverter.getRealArray(array, 0, arrayName, false);
    }

    private static double[] getRealArray(COSObject array, int estimatedSize, String arrayName, boolean checkSize) {
        if (arrayName == null) {
            throw new IllegalArgumentException("Array object can not be null");
        }
        if (array != null && array.getType() == COSObjType.COS_ARRAY) {
            int size = array.size();
            if (checkSize && size != estimatedSize) {
                LOGGER.log(Level.FINE, arrayName + " array doesn't consist of " + estimatedSize + " elements");
            }
            double[] res = new double[size];
            for (int i = 0; i < size; ++i) {
                COSObject number = array.at(i);
                if (number == null || number.getReal() == null) {
                    LOGGER.log(Level.FINE, arrayName + " array contains non number value");
                    return null;
                }
                res[i] = number.getReal();
            }
            return res;
        }
        return null;
    }
}

