/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.filters;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASOutputStream;

public abstract class ASOutFilter
implements ASOutputStream {
    private ASOutputStream storedOutputStream;

    protected ASOutFilter(ASOutputStream outStream) {
        this.storedOutputStream = outStream;
    }

    protected ASOutputStream getStoredOutputStream() {
        return this.storedOutputStream;
    }

    private ASOutFilter(ASOutFilter filter) {
        this.close();
    }

    @Override
    public long write(byte[] buffer) throws IOException {
        return this.storedOutputStream != null ? this.storedOutputStream.write(buffer) : 0L;
    }

    @Override
    public long write(byte[] buffer, int offset, int size) throws IOException {
        return this.storedOutputStream != null ? this.storedOutputStream.write(buffer, offset, size) : 0L;
    }

    @Override
    public long write(ASInputStream stream) throws IOException {
        byte[] buf = new byte[2048];
        int read = stream.read(buf, buf.length);
        int res = 0;
        while (read != -1) {
            this.write(buf, 0, read);
            res += read;
            read = stream.read(buf, buf.length);
        }
        return res;
    }

    @Override
    public void close() {
        this.storedOutputStream = null;
    }
}

