/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.pd.PDObject;

public class PDNameTreeNode
extends PDObject {
    private Set<COSKey> parents = null;
    private List<PDNameTreeNode> kids = null;
    private Map<String, COSObject> names = null;

    private PDNameTreeNode(COSObject obj, Set<COSKey> parents) {
        super(obj);
        COSKey objectKey = obj.getObjectKey();
        this.parents = new HashSet<COSKey>(parents);
        if (objectKey != null) {
            if (parents.contains(objectKey)) {
                throw new LoopedException("Loop in name tree");
            }
            this.parents.add(objectKey);
        }
    }

    public static PDNameTreeNode create(COSObject object) {
        if (object == null || !object.getType().isDictionaryBased()) {
            throw new IllegalArgumentException("Argument object shall be dictionary or stream type");
        }
        return new PDNameTreeNode(object, new HashSet<COSKey>());
    }

    public List<PDNameTreeNode> getKids() {
        if (this.kids == null) {
            this.kids = this.parseKids();
        }
        return Collections.unmodifiableList(this.kids);
    }

    private List<PDNameTreeNode> parseKids() {
        COSObject kids = this.getKey(ASAtom.KIDS);
        if (kids != null && kids.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDNameTreeNode> res = new ArrayList<PDNameTreeNode>();
            for (COSObject obj : (COSArray)kids.getDirectBase()) {
                if (obj == null || !obj.getType().isDictionaryBased()) continue;
                res.add(new PDNameTreeNode(obj, this.parents));
            }
            return res;
        }
        return Collections.emptyList();
    }

    public Map<String, COSObject> getNames() {
        if (this.names == null) {
            this.names = this.parseNames();
        }
        return Collections.unmodifiableMap(this.names);
    }

    private Map<String, COSObject> parseNames() {
        COSObject names = this.getKey(ASAtom.NAMES);
        if (names != null && names.getType() == COSObjType.COS_ARRAY) {
            LinkedHashMap<String, COSObject> res = new LinkedHashMap<String, COSObject>();
            for (int i = 0; i < names.size(); i += 2) {
                String key;
                COSObject keyObj = names.at(i);
                String string = key = keyObj == null ? null : keyObj.getString();
                if (key == null) continue;
                COSObject value = names.at(i + 1);
                res.put(key, value);
            }
            return res;
        }
        return Collections.emptyMap();
    }
}

