/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.io;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;

public class ASConcatenatedInputStream
extends ASInputStream {
    private final ASInputStream[] streams;
    private int index = 0;

    public ASConcatenatedInputStream(ASInputStream[] streams) {
        this.streams = streams;
        this.incrementResourceUsers();
    }

    @Override
    public int read() throws IOException {
        if (this.index == this.streams.length) {
            return -1;
        }
        int newByte = this.streams[this.index].read();
        if (newByte != -1) {
            return newByte;
        }
        return ++this.index == this.streams.length ? -1 : 13;
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        if (buffer.length < size) {
            throw new IOException("Can't write bytes into passed buffer: too small.");
        }
        if (this.index == this.streams.length || size < 0) {
            return -1;
        }
        int bufferIndex = 0;
        int left = size;
        while (left != 0 && this.index != this.streams.length) {
            byte[] temp = new byte[left];
            int read = this.streams[this.index].read(temp, left);
            if (read > 0) {
                System.arraycopy(temp, 0, buffer, bufferIndex, read);
                bufferIndex += read;
                left -= read;
            }
            if (left == 0 || ++this.index == this.streams.length) continue;
            buffer[bufferIndex++] = 13;
            --left;
        }
        return size - left;
    }

    @Override
    public int skip(int size) throws IOException {
        if (this.index == this.streams.length || size <= 0) {
            return 0;
        }
        int left = size;
        while (left != 0 && this.index != this.streams.length) {
            int skipped;
            if ((left -= (skipped = this.streams[this.index].skip(left))) <= 0 || ++this.index == this.streams.length) continue;
            --left;
        }
        return size - left;
    }

    @Override
    public void reset() throws IOException {
        for (ASInputStream as : this.streams) {
            as.reset();
        }
        this.index = 0;
    }

    @Override
    public void closeResource() throws IOException {
        for (ASInputStream as : this.streams) {
            as.closeResource();
        }
    }

    @Override
    public void incrementResourceUsers() {
        for (ASInputStream as : this.streams) {
            as.incrementResourceUsers();
        }
    }

    @Override
    public void decrementResourceUsers() {
        for (ASInputStream as : this.streams) {
            as.decrementResourceUsers();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.decrementResourceUsers();
            this.isClosed = true;
            for (ASInputStream as : this.streams) {
                as.close();
            }
        }
    }
}

