/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.tools.TypeConverter;

public abstract class PDCIEDictionaryBased
extends PDColorSpace {
    private static final double[] DEFAULT_BLACK_POINT = new double[]{0.0, 0.0, 0.0};
    protected COSObject dictionary;

    protected PDCIEDictionaryBased() {
        this(COSDictionary.construct());
    }

    protected PDCIEDictionaryBased(COSObject obj) {
        super(obj);
        COSObject dict = obj.at(1);
        this.dictionary = dict == null || dict.getType() != COSObjType.COS_DICT ? COSDictionary.construct() : dict;
    }

    public double[] getWhitePoint() {
        return PDCIEDictionaryBased.getTristimulus(this.dictionary.getKey(ASAtom.WHITE_POINT));
    }

    public double[] getBlackPoint() {
        double[] res = PDCIEDictionaryBased.getTristimulus(this.dictionary.getKey(ASAtom.BLACK_POINT));
        return res == null ? DEFAULT_BLACK_POINT : res;
    }

    private static double[] getTristimulus(COSObject object) {
        return TypeConverter.getRealArray(object, 3, "Tristimulus");
    }
}

