/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDCIDSystemInfo;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.PDCMap;

public class PDType0Font
extends PDCIDFont {
    private static final Logger LOGGER = Logger.getLogger(PDType0Font.class.getCanonicalName());
    private static final String UCS2 = "UCS2";
    private static final String IDENTITY_H = "Identity-H";
    private static final String IDENTITY_V = "Identity-V";
    private static final String JAPAN_1 = "Japan1";
    private static final String KOREA_1 = "Korea1";
    private static final String GB_1 = "GB1";
    private static final String CNS_1 = "CNS1";
    private static final String ADOBE = "Adobe";
    private PDCMap pdcMap;
    private PDCMap ucsCMap;
    private COSDictionary type0FontDict;

    public PDType0Font(COSDictionary dictionary) {
        super(PDType0Font.getDescendantCOSDictionary(dictionary));
        this.type0FontDict = dictionary == null ? (COSDictionary)COSDictionary.construct().get() : dictionary;
        this.cMap = this.getCMap().getCMapFile();
    }

    public PDCMap getCMap() {
        if (this.pdcMap == null) {
            COSObject cMap = this.type0FontDict.getKey(ASAtom.ENCODING);
            if (!cMap.empty()) {
                PDCMap pdcMap;
                this.pdcMap = pdcMap = new PDCMap(cMap);
                return pdcMap;
            }
            return null;
        }
        return this.pdcMap;
    }

    private static COSDictionary getDescendantCOSDictionary(COSDictionary dict) {
        COSArray array;
        if (dict != null && (array = (COSArray)dict.getKey(ASAtom.DESCENDANT_FONTS).getDirectBase()) != null) {
            return (COSDictionary)array.at(0).getDirectBase();
        }
        return null;
    }

    public COSObject getDescendantFontObject() {
        COSArray array;
        if (this.type0FontDict != null && (array = (COSArray)this.type0FontDict.getKey(ASAtom.DESCENDANT_FONTS).getDirectBase()) != null) {
            return array.at(0);
        }
        return null;
    }

    public COSDictionary getDescendantFont() {
        return PDType0Font.getDescendantCOSDictionary(this.type0FontDict);
    }

    @Override
    public String toUnicode(int code) {
        String unicode;
        if (this.toUnicodeCMap == null) {
            this.toUnicodeCMap = new PDCMap(this.type0FontDict.getKey(ASAtom.TO_UNICODE));
        }
        if ((unicode = super.toUnicode(code)) != null) {
            return unicode;
        }
        if (this.ucsCMap != null) {
            return this.ucsCMap.toUnicode(code);
        }
        if (IDENTITY_H.equals(this.pdcMap.getCMapName()) || IDENTITY_V.equals(this.pdcMap.getCMapName())) {
            this.setUcsCMapFromIdentity(this.getCIDSystemInfo());
            if (this.ucsCMap == null) {
                LOGGER.log(Level.FINE, "Can't create toUnicode CMap from " + this.pdcMap.getCMapName());
                return null;
            }
            return this.ucsCMap.toUnicode(code);
        }
        PDCMap pdcMap = this.getCMap();
        if (pdcMap != null && pdcMap.getCMapFile() != null) {
            int cid = pdcMap.getCMapFile().toCID(code);
            String registry = pdcMap.getRegistry();
            String ordering = pdcMap.getOrdering();
            String ucsName = registry + "-" + ordering + "-" + UCS2;
            PDCMap pdUCSCMap = new PDCMap(COSName.construct(ucsName));
            CMap ucsCMap = pdUCSCMap.getCMapFile();
            if (ucsCMap != null) {
                this.ucsCMap = pdUCSCMap;
                return ucsCMap.getUnicode(cid);
            }
            LOGGER.log(Level.FINE, "Can't load CMap " + ucsName);
            return null;
        }
        LOGGER.log(Level.FINE, "Can't get CMap for font " + this.getName());
        return null;
    }

    private void setUcsCMapFromIdentity(PDCIDSystemInfo cidSystemInfo) {
        String ordering;
        String registry;
        if (cidSystemInfo != null && ADOBE.equals(registry = cidSystemInfo.getRegistry()) && (JAPAN_1.equals(ordering = cidSystemInfo.getOrdering()) || CNS_1.equals(ordering) || KOREA_1.equals(ordering) || GB_1.equals(ordering))) {
            String ucsName = "Adobe-" + ordering + "-" + UCS2;
            this.ucsCMap = new PDCMap(COSName.construct(ucsName));
        }
    }

    public void setFontProgramFromDescendant(PDCIDFont descendant) {
        this.fontProgram = descendant.fontProgram;
        this.isFontParsed = true;
    }

    public COSDictionary getType0FontDict() {
        return this.type0FontDict;
    }

    @Override
    public ASAtom getSubtype() {
        return this.type0FontDict.getNameKey(ASAtom.SUBTYPE);
    }

    public int toCID(int code) {
        return this.pdcMap.getCMapFile().toCID(code);
    }

    @Override
    public COSObject getObject() {
        return new COSObject(this.type0FontDict);
    }
}

