/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.filters;

import java.io.IOException;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.ASInFilter;
import org.verapdf.as.filters.ASOutFilter;
import org.verapdf.as.filters.IASFilterFactory;
import org.verapdf.as.filters.io.ASBufferingOutFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASOutputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.filters.COSFilterASCII85Decode;
import org.verapdf.cos.filters.COSFilterASCIIHexDecode;
import org.verapdf.cos.filters.COSFilterFlateDecode;
import org.verapdf.cos.filters.COSFilterFlateEncode;
import org.verapdf.cos.filters.COSFilterLZWDecode;
import org.verapdf.cos.filters.COSPredictorDecode;

public class ASFilterFactory
implements IASFilterFactory {
    private ASAtom filterType;

    public ASFilterFactory(ASAtom filterType) {
        this.filterType = filterType;
    }

    @Override
    public ASInFilter getInFilter(ASInputStream inputStream, COSDictionary decodeParams) throws IOException {
        switch (this.filterType.getValue()) {
            case "ASCIIHexDecode": {
                return new COSFilterASCIIHexDecode(inputStream);
            }
            case "FlateDecode": {
                return new COSPredictorDecode((ASInputStream)new COSFilterFlateDecode(inputStream), decodeParams);
            }
            case "ASCII85Decode": {
                return new COSFilterASCII85Decode(inputStream);
            }
            case "LZWDecode": {
                return new COSPredictorDecode((ASInputStream)new COSFilterLZWDecode(inputStream, decodeParams), decodeParams);
            }
        }
        throw new IOException("Filter " + this.filterType.getValue() + " is not supported.");
    }

    @Override
    public ASOutFilter getOutFilter(ASOutputStream outputStream) throws IOException {
        switch (this.filterType.getValue()) {
            case "ASCIIHexDecode": {
                return new ASBufferingOutFilter(outputStream);
            }
            case "FlateDecode": {
                return new COSFilterFlateEncode(outputStream);
            }
        }
        throw new IOException("Filter " + this.filterType.getValue() + " is not supported.");
    }
}

